/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.agents.api.resource;

/**
 * Type enum of resource.
 *
 * <p>Currently, support chat models, embedding models, vector stores, tools, and prompts.
 */
public enum ResourceType {
    CHAT_MODEL("chat_model"),
    CHAT_MODEL_CONNECTION("chat_model_connection"),
    EMBEDDING_MODEL("embedding_model"),
    EMBEDDING_MODEL_CONNECTION("embedding_model_connection"),
    VECTOR_STORE("vector_store"),
    PROMPT("prompt"),
    TOOL("tool");

    private final String value;

    ResourceType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    /**
     * Get ResourceType from string value.
     *
     * @param value the string value
     * @return the corresponding ResourceType
     * @throws IllegalArgumentException if no matching ResourceType is found
     */
    public static ResourceType fromValue(String value) {
        for (ResourceType type : ResourceType.values()) {
            if (type.value.equals(value)) {
                return type;
            }
        }
        throw new IllegalArgumentException("Unknown ResourceType value: " + value);
    }
}
