/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.application;

import java.util.HashMap;
import java.util.Map;
import org.grails.forge.application.ProjectIdentifier;
import org.grails.forge.util.NameUtils;

public class Project
extends ProjectIdentifier {
    private static final String PACKAGE_NAME = "packageName";
    private static final String PACKAGE_PATH = "packagePath";
    private static final String CLASS_NAME = "className";
    private static final String NATURAL_NAME = "naturalName";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String NAME = "name";
    private final String packagePath;
    private final String className;
    private final String naturalName;
    private final String propertyName;

    public Project(String packageName, String packagePath, String className, String naturalName, String propertyName, String name) {
        super(packageName, name);
        this.packagePath = packagePath;
        this.className = className;
        this.naturalName = naturalName;
        this.propertyName = propertyName;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public String getClassName() {
        return this.className;
    }

    public String getNaturalName() {
        return this.naturalName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(PACKAGE_NAME, this.getPackageName());
        properties.put(PACKAGE_PATH, this.packagePath);
        properties.put(CLASS_NAME, this.className);
        properties.put(NATURAL_NAME, this.naturalName);
        properties.put(PROPERTY_NAME, this.propertyName);
        properties.put(NAME, this.getName());
        return properties;
    }

    public Project withClassName(String className) {
        return new Project(this.getPackageName(), this.packagePath, className, this.naturalName, NameUtils.getPropertyName(className), this.getName());
    }
}

