/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ServiceOperations {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractService.class);

    private ServiceOperations() {
    }

    public static void stop(Service service) {
        if (service != null) {
            service.stop();
        }
    }

    public static Exception stopQuietly(Service service) {
        return ServiceOperations.stopQuietly(LOG, service);
    }

    public static Exception stopQuietly(Log log, Service service) {
        try {
            ServiceOperations.stop(service);
        }
        catch (Exception e) {
            log.warn((Object)("When stopping the service " + service.getName() + " : " + e), (Throwable)e);
            return e;
        }
        return null;
    }

    public static Exception stopQuietly(Logger log, Service service) {
        try {
            ServiceOperations.stop(service);
        }
        catch (Exception e) {
            log.warn("When stopping the service {} : {}", new Object[]{service.getName(), e, e});
            return e;
        }
        return null;
    }

    public static class ServiceListeners {
        private final List<ServiceStateChangeListener> listeners = new ArrayList<ServiceStateChangeListener>();

        public synchronized void add(ServiceStateChangeListener l) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }

        public synchronized boolean remove(ServiceStateChangeListener l) {
            return this.listeners.remove(l);
        }

        public synchronized void reset() {
            this.listeners.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyListeners(Service service) {
            ServiceStateChangeListener[] callbacks;
            ServiceListeners serviceListeners = this;
            synchronized (serviceListeners) {
                callbacks = this.listeners.toArray(new ServiceStateChangeListener[this.listeners.size()]);
            }
            for (ServiceStateChangeListener l : callbacks) {
                l.stateChanged(service);
            }
        }
    }
}

