/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class SnapshotsTable
extends BaseMetadataTable {
    private static final Schema SNAPSHOT_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"committed_at", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)2, (String)"snapshot_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"parent_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)4, (String)"operation", (Type)Types.StringType.get()), Types.NestedField.optional((int)5, (String)"manifest_list", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"summary", (Type)Types.MapType.ofRequired((int)7, (int)8, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});

    SnapshotsTable(Table table) {
        this(table, table.name() + ".snapshots");
    }

    SnapshotsTable(Table table, String name) {
        super(table, name);
    }

    public TableScan newScan() {
        return new SnapshotsTableScan(this.table());
    }

    public Schema schema() {
        return SNAPSHOT_SCHEMA;
    }

    private DataTask task(BaseTableScan scan) {
        return StaticDataTask.of(this.table().io().newInputFile(this.table().operations().current().metadataFileLocation()), this.schema(), scan.schema(), this.table().snapshots(), SnapshotsTable::snapshotToRow);
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.SNAPSHOTS;
    }

    private static StaticDataTask.Row snapshotToRow(Snapshot snap) {
        return StaticDataTask.Row.of(snap.timestampMillis() * 1000L, snap.snapshotId(), snap.parentId(), snap.operation(), snap.manifestListLocation(), snap.summary());
    }

    private class SnapshotsTableScan
    extends StaticTableScan {
        SnapshotsTableScan(Table table) {
            super(table, SNAPSHOT_SCHEMA, MetadataTableType.SNAPSHOTS, (StaticTableScan x$0) -> SnapshotsTable.this.task((BaseTableScan)x$0));
        }

        SnapshotsTableScan(Table table, TableScanContext context) {
            super(table, SNAPSHOT_SCHEMA, MetadataTableType.SNAPSHOTS, x$0 -> SnapshotsTable.this.task((BaseTableScan)x$0), context);
        }

        @Override
        protected TableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
            return new SnapshotsTableScan(table, context);
        }

        @Override
        public CloseableIterable<FileScanTask> planFiles() {
            return CloseableIterable.withNoopClose((Object)SnapshotsTable.this.task(this));
        }
    }
}

