/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authorization.expression;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationRequestContext;
import org.apache.gravitino.authorization.GravitinoAuthorizer;
import org.apache.gravitino.server.authorization.GravitinoAuthorizerProvider;
import org.apache.gravitino.server.authorization.expression.AuthorizationExpressionConverter;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class AuthorizationExpressionEvaluator {
    private final String ognlAuthorizationExpression;
    private final GravitinoAuthorizer authorizer;

    public AuthorizationExpressionEvaluator(String expression) {
        this(expression, GravitinoAuthorizerProvider.getInstance().getGravitinoAuthorizer());
    }

    public AuthorizationExpressionEvaluator(String expression, GravitinoAuthorizer authorizer) {
        this.ognlAuthorizationExpression = AuthorizationExpressionConverter.convertToOgnlExpression(expression);
        this.authorizer = authorizer;
    }

    public boolean evaluate(Map<Entity.EntityType, NameIdentifier> metadataNames, AuthorizationRequestContext requestContext) {
        Principal currentPrincipal = PrincipalUtils.getCurrentPrincipal();
        return this.evaluate(metadataNames, new HashMap<String, Object>(), requestContext, currentPrincipal);
    }

    public boolean evaluate(Map<Entity.EntityType, NameIdentifier> metadataNames, AuthorizationRequestContext requestContext, Principal principal) {
        return this.evaluate(metadataNames, new HashMap<String, Object>(), requestContext, principal);
    }

    public boolean evaluate(Map<Entity.EntityType, NameIdentifier> metadataNames, Map<String, Object> pathParams, AuthorizationRequestContext requestContext) {
        Principal currentPrincipal = PrincipalUtils.getCurrentPrincipal();
        return this.evaluate(metadataNames, pathParams, requestContext, currentPrincipal);
    }

    private boolean evaluate(Map<Entity.EntityType, NameIdentifier> metadataNames, Map<String, Object> pathParams, AuthorizationRequestContext requestContext, Principal currentPrincipal) {
        OgnlContext ognlContext = Ognl.createDefaultContext(null);
        ognlContext.put("principal", (Object)currentPrincipal);
        ognlContext.put("authorizer", (Object)this.authorizer);
        ognlContext.put("authorizationContext", (Object)requestContext);
        ognlContext.putAll(pathParams);
        metadataNames.forEach((type, entityNameIdent) -> {
            if (AuthorizationExpressionEvaluator.isMetadataType(type)) {
                MetadataObject metadataObject = NameIdentifierUtil.toMetadataObject((NameIdentifier)entityNameIdent, (Entity.EntityType)type);
                ognlContext.put(type.name(), (Object)metadataObject);
            }
            ognlContext.put(type.name() + "_NAME_IDENT", entityNameIdent);
        });
        NameIdentifier nameIdentifier = metadataNames.get(Entity.EntityType.METALAKE);
        ognlContext.put("METALAKE_NAME", (Object)Optional.ofNullable(nameIdentifier).map(NameIdentifier::name).orElse(""));
        try {
            return (Boolean)Ognl.getValue((String)this.ognlAuthorizationExpression, (Object)ognlContext);
        }
        catch (OgnlException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isMetadataType(Entity.EntityType type) {
        return Arrays.stream(MetadataObject.Type.values()).anyMatch(e -> Objects.equals(e.name(), type.name()));
    }
}

