/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.encryption.EncryptedInputFile;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;

public class EncryptingFileIO
implements FileIO,
Serializable {
    private final FileIO io;
    private final EncryptionManager em;

    public static EncryptingFileIO combine(FileIO io, EncryptionManager em) {
        if (io instanceof EncryptingFileIO) {
            EncryptingFileIO encryptingIO = (EncryptingFileIO)io;
            if (encryptingIO.em == em) {
                return encryptingIO;
            }
            return EncryptingFileIO.combine(encryptingIO.io, em);
        }
        return new EncryptingFileIO(io, em);
    }

    EncryptingFileIO(FileIO io, EncryptionManager em) {
        this.io = io;
        this.em = em;
    }

    public Map<String, InputFile> bulkDecrypt(Iterable<? extends ContentFile<?>> files) {
        Iterable<InputFile> decrypted = this.em.decrypt(Iterables.transform(files, this::wrap));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (InputFile in : decrypted) {
            builder.put((Object)in.location(), (Object)in);
        }
        return builder.buildKeepingLast();
    }

    public EncryptionManager encryptionManager() {
        return this.em;
    }

    @Override
    public InputFile newInputFile(String path) {
        return this.io.newInputFile(path);
    }

    @Override
    public InputFile newInputFile(String path, long length) {
        return this.io.newInputFile(path, length);
    }

    @Override
    public InputFile newInputFile(DataFile file) {
        return this.newInputFile((ContentFile<?>)file);
    }

    @Override
    public InputFile newInputFile(DeleteFile file) {
        return this.newInputFile((ContentFile<?>)file);
    }

    private InputFile newInputFile(ContentFile<?> file) {
        if (file.keyMetadata() != null) {
            return this.newDecryptingInputFile(file.location(), file.fileSizeInBytes(), file.keyMetadata());
        }
        return this.newInputFile(file.location(), file.fileSizeInBytes());
    }

    @Override
    public InputFile newInputFile(ManifestFile manifest) {
        if (manifest.keyMetadata() != null) {
            return this.newDecryptingInputFile(manifest.path(), manifest.length(), manifest.keyMetadata());
        }
        return this.newInputFile(manifest.path(), manifest.length());
    }

    public InputFile newDecryptingInputFile(String path, ByteBuffer buffer) {
        return this.em.decrypt(EncryptingFileIO.wrap(this.io.newInputFile(path), buffer));
    }

    public InputFile newDecryptingInputFile(String path, long length, ByteBuffer buffer) {
        return this.em.decrypt(EncryptingFileIO.wrap(this.io.newInputFile(path, length), buffer));
    }

    @Override
    public OutputFile newOutputFile(String path) {
        return this.io.newOutputFile(path);
    }

    public EncryptedOutputFile newEncryptingOutputFile(String path) {
        OutputFile plainOutputFile = this.io.newOutputFile(path);
        return this.em.encrypt(plainOutputFile);
    }

    @Override
    public void deleteFile(String path) {
        this.io.deleteFile(path);
    }

    @Override
    public void close() {
        this.io.close();
        if (this.em instanceof Closeable) {
            try {
                ((Closeable)((Object)this.em)).close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close encryption manager", e);
            }
        }
    }

    private SimpleEncryptedInputFile wrap(ContentFile<?> file) {
        InputFile encryptedInputFile = this.io.newInputFile(file.location(), file.fileSizeInBytes());
        return new SimpleEncryptedInputFile(encryptedInputFile, EncryptingFileIO.toKeyMetadata(file.keyMetadata()));
    }

    private static SimpleEncryptedInputFile wrap(InputFile encryptedInputFile, ByteBuffer buffer) {
        return new SimpleEncryptedInputFile(encryptedInputFile, EncryptingFileIO.toKeyMetadata(buffer));
    }

    private static EncryptionKeyMetadata toKeyMetadata(ByteBuffer buffer) {
        return buffer != null ? new SimpleKeyMetadata(buffer) : EmptyKeyMetadata.get();
    }

    private static class EmptyKeyMetadata
    implements EncryptionKeyMetadata {
        private static final EmptyKeyMetadata INSTANCE = new EmptyKeyMetadata();

        private EmptyKeyMetadata() {
        }

        private static EmptyKeyMetadata get() {
            return INSTANCE;
        }

        @Override
        public ByteBuffer buffer() {
            return null;
        }

        @Override
        public EncryptionKeyMetadata copy() {
            return this;
        }
    }

    private static class SimpleKeyMetadata
    implements EncryptionKeyMetadata {
        private final ByteBuffer metadataBuffer;

        private SimpleKeyMetadata(ByteBuffer metadataBuffer) {
            this.metadataBuffer = metadataBuffer;
        }

        @Override
        public ByteBuffer buffer() {
            return this.metadataBuffer;
        }

        @Override
        public EncryptionKeyMetadata copy() {
            return new SimpleKeyMetadata(this.metadataBuffer.duplicate());
        }
    }

    private static class SimpleEncryptedInputFile
    implements EncryptedInputFile {
        private final InputFile encryptedInputFile;
        private final EncryptionKeyMetadata keyMetadata;

        private SimpleEncryptedInputFile(InputFile encryptedInputFile, EncryptionKeyMetadata keyMetadata) {
            this.encryptedInputFile = encryptedInputFile;
            this.keyMetadata = keyMetadata;
        }

        @Override
        public InputFile encryptedInputFile() {
            return this.encryptedInputFile;
        }

        @Override
        public EncryptionKeyMetadata keyMetadata() {
            return this.keyMetadata;
        }
    }
}

