/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface Timer {
    public static final Timer NOOP = new Timer(){

        @Override
        public Timed start() {
            return Timed.NOOP;
        }

        @Override
        public long count() {
            throw new UnsupportedOperationException("NOOP timer has no count");
        }

        @Override
        public Duration totalDuration() {
            throw new UnsupportedOperationException("NOOP timer has no duration");
        }

        @Override
        public TimeUnit unit() {
            throw new UnsupportedOperationException("NOOP timer has no unit");
        }

        @Override
        public void record(long amount, TimeUnit unit) {
        }

        @Override
        public void time(Runnable runnable) {
        }

        @Override
        public <T> T timeCallable(Callable<T> callable) throws Exception {
            return callable.call();
        }

        @Override
        public <T> T time(Supplier<T> supplier) {
            return supplier.get();
        }

        public String toString() {
            return "NOOP timer";
        }
    };

    public long count();

    public Duration totalDuration();

    public Timed start();

    default public TimeUnit unit() {
        return TimeUnit.NANOSECONDS;
    }

    public void record(long var1, TimeUnit var3);

    default public void time(Duration duration) {
        this.record(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public void time(Runnable var1);

    public <T> T timeCallable(Callable<T> var1) throws Exception;

    public <T> T time(Supplier<T> var1);

    default public boolean isNoop() {
        return NOOP.equals(this);
    }

    public static interface Timed
    extends AutoCloseable {
        public static final Timed NOOP = () -> {};

        public void stop();

        @Override
        default public void close() {
            this.stop();
        }
    }
}

