/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class OwnerRelPO {
    Long metalakeId;
    Long ownerId;
    String ownerType;
    Long metadataObjectId;
    String metadataObjectType;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    private OwnerRelPO() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public Long getMetadataObjectId() {
        return this.metadataObjectId;
    }

    public String getMetadataObjectType() {
        return this.metadataObjectType;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public static class Builder {
        private final OwnerRelPO ownerRelPO = new OwnerRelPO();

        private Builder() {
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.ownerRelPO.metalakeId = metalakeId;
            return this;
        }

        public Builder withOwnerId(Long ownerId) {
            this.ownerRelPO.ownerId = ownerId;
            return this;
        }

        public Builder withOwnerType(String ownerType) {
            this.ownerRelPO.ownerType = ownerType;
            return this;
        }

        public Builder withMetadataObjectId(Long metadataObjectId) {
            this.ownerRelPO.metadataObjectId = metadataObjectId;
            return this;
        }

        public Builder withMetadataObjectType(String metadataObjectType) {
            this.ownerRelPO.metadataObjectType = metadataObjectType;
            return this;
        }

        public Builder withAuditIfo(String auditIfo) {
            this.ownerRelPO.auditInfo = auditIfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.ownerRelPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.ownerRelPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeleteAt(Long deleteAt) {
            this.ownerRelPO.deletedAt = deleteAt;
            return this;
        }

        public OwnerRelPO build() {
            this.validate();
            return this.ownerRelPO;
        }

        private void validate() {
            Preconditions.checkArgument((this.ownerRelPO.ownerId != null ? 1 : 0) != 0, (Object)"Owner id is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.ownerRelPO.ownerType), (Object)"Owner type is required");
            Preconditions.checkArgument((this.ownerRelPO.metadataObjectId != null ? 1 : 0) != 0, (Object)"Metadata object id is required");
            Preconditions.checkArgument((this.ownerRelPO.metadataObjectType != null ? 1 : 0) != 0, (Object)"Metadata object type is required");
            Preconditions.checkArgument((this.ownerRelPO.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.ownerRelPO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.ownerRelPO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.ownerRelPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }
    }
}

