/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpClientConnectionFactory;
import org.apache.hadoop.fs.azurebfs.services.AbfsManagedApacheHttpConnection;
import org.apache.hadoop.fs.azurebfs.services.AbfsManagedHttpClientContext;
import org.apache.hadoop.fs.azurebfs.services.KeepAliveCache;
import org.apache.http.HttpClientConnection;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AbfsConnectionManager
implements HttpClientConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsConnectionManager.class);
    private final KeepAliveCache kac;
    private final AbfsHttpClientConnectionFactory httpConnectionFactory;
    private final HttpClientConnectionOperator connectionOperator;

    AbfsConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry, AbfsHttpClientConnectionFactory connectionFactory, KeepAliveCache kac) {
        this.httpConnectionFactory = connectionFactory;
        this.kac = kac;
        this.connectionOperator = new DefaultHttpClientConnectionOperator(socketFactoryRegistry, null, null);
    }

    public ConnectionRequest requestConnection(final HttpRoute route, Object state) {
        return new ConnectionRequest(){

            public HttpClientConnection get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, ConnectionPoolTimeoutException {
                String requestId = UUID.randomUUID().toString();
                AbfsConnectionManager.this.logDebug("Connection requested for request {}", new Object[]{requestId});
                try {
                    HttpClientConnection clientConn = AbfsConnectionManager.this.kac.get();
                    if (clientConn != null) {
                        AbfsConnectionManager.this.logDebug("Connection retrieved from KAC: {} for requestId: {}", new Object[]{clientConn, requestId});
                        return clientConn;
                    }
                    AbfsConnectionManager.this.logDebug("Creating new connection for requestId: {}", new Object[]{requestId});
                    ManagedHttpClientConnection conn = AbfsConnectionManager.this.httpConnectionFactory.create(route, (ConnectionConfig)null);
                    AbfsConnectionManager.this.logDebug("Connection created: {} for requestId: {}", new Object[]{conn, requestId});
                    return conn;
                }
                catch (IOException ex) {
                    throw new ExecutionException(ex);
                }
            }

            public boolean cancel() {
                return false;
            }
        };
    }

    public void releaseConnection(HttpClientConnection conn, Object newState, long validDuration, TimeUnit timeUnit) {
        if (validDuration == 0L) {
            return;
        }
        if (conn.isOpen() && conn instanceof AbfsManagedApacheHttpConnection) {
            boolean connAddedInKac = this.kac.put(conn);
            if (connAddedInKac) {
                this.logDebug("Connection cached: {}", conn);
            } else {
                this.logDebug("Connection not cached, and is released: {}", conn);
            }
        }
    }

    public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
        long start = System.currentTimeMillis();
        this.logDebug("Connecting {} to {}", conn, route.getTargetHost());
        this.connectionOperator.connect((ManagedHttpClientConnection)((AbfsManagedApacheHttpConnection)conn), route.getTargetHost(), route.getLocalSocketAddress(), connectTimeout, SocketConfig.DEFAULT, context);
        this.logDebug("Connection established: {}", conn);
        if (context instanceof AbfsManagedHttpClientContext) {
            ((AbfsManagedHttpClientContext)context).setConnectTime(System.currentTimeMillis() - start);
        }
    }

    public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
        this.connectionOperator.upgrade((ManagedHttpClientConnection)((AbfsManagedApacheHttpConnection)conn), route.getTargetHost(), context);
    }

    public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
    }

    public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
        this.kac.evictIdleConnection();
    }

    public void closeExpiredConnections() {
        this.kac.evictIdleConnection();
    }

    public void shutdown() {
        this.kac.close();
    }

    private void logDebug(String message, Object ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message, args);
        }
    }
}

