/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.util.ReferenceCountMap;
import org.junit.Assert;
import org.junit.Test;

public class TestReferenceCountMap {
    public static final int LOOP_COUNTER = 10000;
    private AclFeature aclFeature1 = new AclFeature(new int[]{1});
    private AclFeature aclFeature2 = new AclFeature(new int[]{2});

    @Test
    public void testReferenceCountMap() throws Exception {
        ReferenceCountMap countMap = new ReferenceCountMap();
        countMap.put((ReferenceCountMap.ReferenceCounter)this.aclFeature1);
        countMap.put((ReferenceCountMap.ReferenceCounter)this.aclFeature2);
        Assert.assertEquals((long)1L, (long)countMap.getReferenceCount((ReferenceCountMap.ReferenceCounter)this.aclFeature1));
        Assert.assertEquals((long)1L, (long)countMap.getReferenceCount((ReferenceCountMap.ReferenceCounter)this.aclFeature2));
        countMap.put((ReferenceCountMap.ReferenceCounter)this.aclFeature1);
        countMap.put((ReferenceCountMap.ReferenceCounter)this.aclFeature2);
        Assert.assertEquals((long)2L, (long)countMap.getReferenceCount((ReferenceCountMap.ReferenceCounter)this.aclFeature1));
        Assert.assertEquals((long)2L, (long)countMap.getReferenceCount((ReferenceCountMap.ReferenceCounter)this.aclFeature2));
        countMap.put((ReferenceCountMap.ReferenceCounter)this.aclFeature1);
        Assert.assertEquals((long)3L, (long)countMap.getReferenceCount((ReferenceCountMap.ReferenceCounter)this.aclFeature1));
        countMap.put((ReferenceCountMap.ReferenceCounter)this.aclFeature1);
        Assert.assertEquals((long)4L, (long)countMap.getReferenceCount((ReferenceCountMap.ReferenceCounter)this.aclFeature1));
        Assert.assertEquals((long)2L, (long)countMap.getReferenceCount((ReferenceCountMap.ReferenceCounter)this.aclFeature2));
        countMap.remove((ReferenceCountMap.ReferenceCounter)this.aclFeature1);
        countMap.remove((ReferenceCountMap.ReferenceCounter)this.aclFeature2);
        Assert.assertEquals((long)3L, (long)countMap.getReferenceCount((ReferenceCountMap.ReferenceCounter)this.aclFeature1));
        Assert.assertEquals((long)1L, (long)countMap.getReferenceCount((ReferenceCountMap.ReferenceCounter)this.aclFeature2));
        Assert.assertEquals((long)2L, (long)countMap.getUniqueElementsSize());
    }

    @Test
    public void testRefCountMapConcurrently() throws Exception {
        ReferenceCountMap countMap = new ReferenceCountMap();
        PutThread putThread1 = new PutThread((ReferenceCountMap<AclFeature>)countMap);
        putThread1.start();
        PutThread putThread2 = new PutThread((ReferenceCountMap<AclFeature>)countMap);
        putThread2.start();
        RemoveThread removeThread1 = new RemoveThread((ReferenceCountMap<AclFeature>)countMap);
        putThread1.join();
        putThread2.join();
        Assert.assertEquals((long)20000L, (long)countMap.getReferenceCount((ReferenceCountMap.ReferenceCounter)this.aclFeature1));
        Assert.assertEquals((long)20000L, (long)countMap.getReferenceCount((ReferenceCountMap.ReferenceCounter)this.aclFeature2));
        removeThread1.start();
        removeThread1.join();
        Assert.assertEquals((long)10000L, (long)countMap.getReferenceCount((ReferenceCountMap.ReferenceCounter)this.aclFeature1));
        Assert.assertEquals((long)10000L, (long)countMap.getReferenceCount((ReferenceCountMap.ReferenceCounter)this.aclFeature2));
    }

    class RemoveThread
    extends Thread {
        private ReferenceCountMap<AclFeature> referenceCountMap;

        RemoveThread(ReferenceCountMap<AclFeature> referenceCountMap) {
            this.referenceCountMap = referenceCountMap;
        }

        @Override
        public void run() {
            for (int i = 0; i < 10000; ++i) {
                this.referenceCountMap.remove((ReferenceCountMap.ReferenceCounter)TestReferenceCountMap.this.aclFeature1);
                this.referenceCountMap.remove((ReferenceCountMap.ReferenceCounter)TestReferenceCountMap.this.aclFeature2);
            }
        }
    }

    class PutThread
    extends Thread {
        private ReferenceCountMap<AclFeature> referenceCountMap;

        PutThread(ReferenceCountMap<AclFeature> referenceCountMap) {
            this.referenceCountMap = referenceCountMap;
        }

        @Override
        public void run() {
            for (int i = 0; i < 10000; ++i) {
                this.referenceCountMap.put((ReferenceCountMap.ReferenceCounter)TestReferenceCountMap.this.aclFeature1);
                this.referenceCountMap.put((ReferenceCountMap.ReferenceCounter)TestReferenceCountMap.this.aclFeature2);
            }
        }
    }
}

