/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import org.ojalgo.ProgrammingError;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.function.PrimitiveFunction;

public final class CharacteristicLine {
    public double beta;
    public double alpha;
    public double epsilon;
    private final FinancePortfolio myMarketPortfolio;

    public CharacteristicLine(FinancePortfolio theMarketPortfolio) {
        this.myMarketPortfolio = theMarketPortfolio;
    }

    private CharacteristicLine() {
        this(null);
        ProgrammingError.throwForIllegalInvocation();
    }

    public double calculateBeta(FinancePortfolio anyAsset) {
        return anyAsset.getMeanReturn() / this.myMarketPortfolio.getMeanReturn();
    }

    public double calculateCorrelation(FinancePortfolio anyAsset) {
        double tmpCovar = this.calculateCovariance(anyAsset);
        double tmpVal = this.myMarketPortfolio.getReturnVariance() * anyAsset.getReturnVariance();
        return tmpCovar / PrimitiveFunction.SQRT.invoke(tmpVal);
    }

    public double calculateCovariance(FinancePortfolio anyAsset) {
        double tmpBeta = this.calculateBeta(anyAsset);
        return this.myMarketPortfolio.getReturnVariance() * tmpBeta;
    }
}

