/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.s3.analyticsaccelerator.ObjectClientConfiguration;
import software.amazon.s3.analyticsaccelerator.ObjectClientTelemetry;
import software.amazon.s3.analyticsaccelerator.common.telemetry.ConfigurableTelemetry;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.request.GetRequest;
import software.amazon.s3.analyticsaccelerator.request.HeadRequest;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectContent;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.request.RequestFactory;
import software.amazon.s3.analyticsaccelerator.request.UserAgent;
import software.amazon.s3.analyticsaccelerator.util.ObjectClientUtil;
import software.amazon.s3.analyticsaccelerator.util.OpenStreamInformation;

public class S3SdkObjectClient
implements ObjectClient {
    @NonNull
    private final S3AsyncClient s3AsyncClient;
    @NonNull
    private final Telemetry telemetry;
    @NonNull
    private final UserAgent userAgent;
    private final boolean closeAsyncClient;
    RequestFactory requestFactory;

    public S3SdkObjectClient(@NonNull S3AsyncClient s3AsyncClient) {
        this(s3AsyncClient, ObjectClientConfiguration.DEFAULT);
        if (s3AsyncClient == null) {
            throw new NullPointerException("s3AsyncClient is marked non-null but is null");
        }
    }

    public S3SdkObjectClient(@NonNull S3AsyncClient s3AsyncClient, boolean closeAsyncClient) {
        this(s3AsyncClient, ObjectClientConfiguration.DEFAULT, closeAsyncClient);
        if (s3AsyncClient == null) {
            throw new NullPointerException("s3AsyncClient is marked non-null but is null");
        }
    }

    public S3SdkObjectClient(@NonNull S3AsyncClient s3AsyncClient, @NonNull ObjectClientConfiguration objectClientConfiguration) {
        this(s3AsyncClient, objectClientConfiguration, true);
        if (s3AsyncClient == null) {
            throw new NullPointerException("s3AsyncClient is marked non-null but is null");
        }
        if (objectClientConfiguration == null) {
            throw new NullPointerException("objectClientConfiguration is marked non-null but is null");
        }
    }

    public S3SdkObjectClient(@NonNull S3AsyncClient s3AsyncClient, @NonNull ObjectClientConfiguration objectClientConfiguration, boolean closeAsyncClient) {
        if (s3AsyncClient == null) {
            throw new NullPointerException("s3AsyncClient is marked non-null but is null");
        }
        if (objectClientConfiguration == null) {
            throw new NullPointerException("objectClientConfiguration is marked non-null but is null");
        }
        this.s3AsyncClient = s3AsyncClient;
        this.closeAsyncClient = closeAsyncClient;
        this.telemetry = new ConfigurableTelemetry(objectClientConfiguration.getTelemetryConfiguration());
        this.userAgent = new UserAgent();
        this.userAgent.prepend(objectClientConfiguration.getUserAgentPrefix());
        String customUserAgent = Optional.ofNullable(s3AsyncClient.serviceClientConfiguration()).map(SdkServiceClientConfiguration::overrideConfiguration).flatMap(override -> override.advancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX)).orElse("");
        this.userAgent.prepend(customUserAgent);
        this.requestFactory = new RequestFactory(this.userAgent);
    }

    @Override
    public void close() {
        if (this.closeAsyncClient) {
            this.s3AsyncClient.close();
        }
    }

    @Override
    public ObjectMetadata headObject(HeadRequest headRequest, OpenStreamInformation openStreamInformation) throws IOException {
        HeadObjectRequest.Builder builder = this.requestFactory.buildHeadObjectRequest(headRequest, openStreamInformation);
        return this.telemetry.measureCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name("s3.client.head")).attribute(ObjectClientTelemetry.uri(headRequest.getS3Uri()))).build(), () -> {
            try {
                HeadObjectResponse headObjectResponse = (HeadObjectResponse)this.s3AsyncClient.headObject((HeadObjectRequest)builder.build()).get();
                return ObjectMetadata.builder().contentLength(headObjectResponse.contentLength()).etag(headObjectResponse.eTag()).build();
            }
            catch (Throwable t) {
                throw ObjectClientUtil.handleException(headRequest.getS3Uri(), t);
            }
        });
    }

    @Override
    public ObjectContent getObject(GetRequest getRequest, OpenStreamInformation openStreamInformation) throws IOException {
        GetObjectRequest.Builder builder = this.requestFactory.getObjectRequest(getRequest, openStreamInformation);
        return this.telemetry.measureCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name("s3.client.get")).attribute(ObjectClientTelemetry.uri(getRequest.getS3Uri()))).attribute(ObjectClientTelemetry.rangeLength(getRequest.getRange()))).attribute(ObjectClientTelemetry.range(getRequest.getRange()))).build(), () -> {
            try {
                ResponseInputStream inputStream = (ResponseInputStream)this.s3AsyncClient.getObject((GetObjectRequest)builder.build(), AsyncResponseTransformer.toBlockingInputStream()).get();
                return ObjectContent.builder().stream((InputStream)inputStream).build();
            }
            catch (Throwable t) {
                throw ObjectClientUtil.handleException(getRequest.getS3Uri(), t);
            }
        });
    }

    @NonNull
    @Generated
    public S3AsyncClient getS3AsyncClient() {
        return this.s3AsyncClient;
    }
}

