/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.shaded.javax.websocket.EncodeException;
import org.apache.hadoop.shaded.javax.websocket.RemoteEndpoint;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.BufferUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.WebSocketSession;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.MessageOutputStream;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.MessageWriter;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.util.TextUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.AbstractJsrRemote;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.JsrSession;

public class JsrBasicRemote
extends AbstractJsrRemote
implements RemoteEndpoint.Basic {
    private static final Logger LOG = Log.getLogger(JsrBasicRemote.class);

    protected JsrBasicRemote(JsrSession session) {
        super(session);
    }

    @Override
    public OutputStream getSendStream() throws IOException {
        return new MessageOutputStream((WebSocketSession)this.session);
    }

    @Override
    public Writer getSendWriter() throws IOException {
        return new MessageWriter((WebSocketSession)this.session);
    }

    @Override
    public void sendBinary(ByteBuffer data) throws IOException {
        this.assertMessageNotNull(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({})", new Object[]{BufferUtil.toDetailString((ByteBuffer)data)});
        }
        this.jettyRemote.sendBytes(data);
    }

    @Override
    public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
        this.assertMessageNotNull(partialByte);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({},{})", new Object[]{BufferUtil.toDetailString((ByteBuffer)partialByte), isLast});
        }
        this.jettyRemote.sendPartialBytes(partialByte, isLast);
    }

    @Override
    public void sendObject(Object data) throws IOException, EncodeException {
        Future<Void> fut = this.sendObjectViaFuture(data);
        try {
            fut.get();
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to write object", e.getCause());
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to write object", e);
        }
    }

    @Override
    public void sendText(String text) throws IOException {
        this.assertMessageNotNull(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({})", new Object[]{TextUtil.hint((String)text)});
        }
        this.jettyRemote.sendString(text);
    }

    @Override
    public void sendText(String partialMessage, boolean isLast) throws IOException {
        this.assertMessageNotNull(partialMessage);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({},{})", new Object[]{TextUtil.hint((String)partialMessage), isLast});
        }
        this.jettyRemote.sendPartialString(partialMessage, isLast);
    }
}

