/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.webapp.WebServices;
import org.apache.hadoop.yarn.webapp.BadRequestException;

public class ApplicationsRequestBuilder {
    private Set<String> statesQuery = Sets.newHashSet();
    private Set<String> users = Sets.newHashSetWithExpectedSize((int)1);
    private Set<String> queues = Sets.newHashSetWithExpectedSize((int)1);
    private String limit = null;
    private Long limitNumber;
    private long startedTimeBegin = 0L;
    private long startedTimeEnd = Long.MAX_VALUE;
    private long finishTimeBegin = 0L;
    private long finishTimeEnd = Long.MAX_VALUE;
    private Set<String> appTypes = Sets.newHashSet();
    private Set<String> appTags = Sets.newHashSet();
    private String name = null;
    private ResourceManager rm;

    private ApplicationsRequestBuilder() {
    }

    public static ApplicationsRequestBuilder create() {
        return new ApplicationsRequestBuilder();
    }

    public ApplicationsRequestBuilder withStateQuery(String stateQuery) {
        if (stateQuery != null && !stateQuery.isEmpty()) {
            this.statesQuery.add(stateQuery);
        }
        return this;
    }

    public ApplicationsRequestBuilder withStatesQuery(Set<String> statesQuery) {
        if (statesQuery != null) {
            this.statesQuery.addAll(statesQuery);
        }
        return this;
    }

    public ApplicationsRequestBuilder withUserQuery(String userQuery) {
        if (userQuery != null && !userQuery.isEmpty()) {
            this.users.add(userQuery);
        }
        return this;
    }

    public ApplicationsRequestBuilder withQueueQuery(ResourceManager rm, String queueQuery) {
        this.rm = rm;
        if (queueQuery != null && !queueQuery.isEmpty()) {
            this.queues.add(queueQuery);
        }
        return this;
    }

    public ApplicationsRequestBuilder withLimit(String limit) {
        if (limit != null && !limit.isEmpty()) {
            this.limit = limit;
        }
        return this;
    }

    public ApplicationsRequestBuilder withStartedTimeBegin(String startedBegin) {
        if (startedBegin != null && !startedBegin.isEmpty()) {
            this.startedTimeBegin = this.parseLongValue(startedBegin, "startedTimeBegin");
        }
        return this;
    }

    public ApplicationsRequestBuilder withStartedTimeEnd(String startedEnd) {
        if (startedEnd != null && !startedEnd.isEmpty()) {
            this.startedTimeEnd = this.parseLongValue(startedEnd, "startedTimeEnd");
        }
        return this;
    }

    public ApplicationsRequestBuilder withFinishTimeBegin(String finishBegin) {
        if (finishBegin != null && !finishBegin.isEmpty()) {
            this.finishTimeBegin = this.parseLongValue(finishBegin, "finishedTimeBegin");
        }
        return this;
    }

    public ApplicationsRequestBuilder withFinishTimeEnd(String finishEnd) {
        if (finishEnd != null && !finishEnd.isEmpty()) {
            this.finishTimeEnd = this.parseLongValue(finishEnd, "finishedTimeEnd");
        }
        return this;
    }

    public ApplicationsRequestBuilder withApplicationTypes(Set<String> applicationTypes) {
        if (applicationTypes != null) {
            this.appTypes = WebServices.parseQueries(applicationTypes, false);
        }
        return this;
    }

    public ApplicationsRequestBuilder withApplicationTags(Set<String> applicationTags) {
        if (applicationTags != null) {
            this.appTags = WebServices.parseQueries(applicationTags, false);
        }
        return this;
    }

    public ApplicationsRequestBuilder withName(String applicationName) {
        this.name = applicationName;
        return this;
    }

    private void validate() {
        this.queues.forEach(q -> this.validateQueueExists(this.rm, (String)q));
        this.validateLimit();
        this.validateStartTime();
        this.validateFinishTime();
    }

    private void validateQueueExists(ResourceManager rm, String queueQuery) {
        ResourceScheduler rs = rm.getResourceScheduler();
        if (rs instanceof CapacityScheduler) {
            CapacityScheduler cs = (CapacityScheduler)rs;
            try {
                cs.getQueueInfo(queueQuery, false, false);
            }
            catch (IOException e) {
                throw new BadRequestException(e.getMessage());
            }
        }
    }

    private void validateLimit() {
        if (this.limit != null) {
            this.limitNumber = this.parseLongValue(this.limit, "limit");
            if (this.limitNumber <= 0L) {
                throw new BadRequestException("limit value must be greater then 0");
            }
        }
    }

    private long parseLongValue(String strValue, String queryName) {
        try {
            return Long.parseLong(strValue);
        }
        catch (NumberFormatException e) {
            throw new BadRequestException(queryName + " value must be a number!");
        }
    }

    private void validateStartTime() {
        if (this.startedTimeBegin < 0L) {
            throw new BadRequestException("startedTimeBegin must be greater than 0");
        }
        if (this.startedTimeEnd < 0L) {
            throw new BadRequestException("startedTimeEnd must be greater than 0");
        }
        if (this.startedTimeBegin > this.startedTimeEnd) {
            throw new BadRequestException("startedTimeEnd must be greater than startTimeBegin");
        }
    }

    private void validateFinishTime() {
        if (this.finishTimeBegin < 0L) {
            throw new BadRequestException("finishTimeBegin must be greater than 0");
        }
        if (this.finishTimeEnd < 0L) {
            throw new BadRequestException("finishTimeEnd must be greater than 0");
        }
        if (this.finishTimeBegin > this.finishTimeEnd) {
            throw new BadRequestException("finishTimeEnd must be greater than finishTimeBegin");
        }
    }

    public GetApplicationsRequest build() {
        this.validate();
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        Set<String> appStates = WebServices.parseQueries(this.statesQuery, true);
        if (!appStates.isEmpty()) {
            request.setApplicationStates(appStates);
        }
        if (!this.users.isEmpty()) {
            request.setUsers(this.users);
        }
        if (!this.queues.isEmpty()) {
            request.setQueues(this.queues);
        }
        if (this.limitNumber != null) {
            request.setLimit(this.limitNumber.longValue());
        }
        request.setStartRange(this.startedTimeBegin, this.startedTimeEnd);
        request.setFinishRange(this.finishTimeBegin, this.finishTimeEnd);
        if (!this.appTypes.isEmpty()) {
            request.setApplicationTypes(this.appTypes);
        }
        if (!this.appTags.isEmpty()) {
            request.setApplicationTags(this.appTags);
        }
        if (this.name != null) {
            request.setName(this.name);
        }
        return request;
    }
}

