/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.bzip2;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.bzip2.CBZip2OutputStream;
import org.apache.hadoop.util.Preconditions;

public final class BZip2TextFileWriter
implements Closeable {
    private static final int BLOCK_SIZE_100K = 1;
    public static final int BLOCK_SIZE = CBZip2OutputStream.getAllowableBlockSize((int)1) + 1;
    private final CBZip2OutputStream out;

    public BZip2TextFileWriter(Path path, Configuration conf) throws IOException {
        this((OutputStream)path.getFileSystem(conf).create(path));
    }

    public BZip2TextFileWriter(OutputStream rawOut) throws IOException {
        try {
            BZip2Codec.writeHeader((OutputStream)rawOut);
            this.out = new CBZip2OutputStream(rawOut, 1);
        }
        catch (Throwable e) {
            rawOut.close();
            throw e;
        }
    }

    public void writeManyRecords(int totalSize, int numRecords, byte[] delimiter) throws IOException {
        Preconditions.checkArgument((numRecords > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((delimiter.length > 0 ? 1 : 0) != 0);
        int minRecordSize = totalSize / numRecords;
        Preconditions.checkArgument((minRecordSize >= delimiter.length ? 1 : 0) != 0);
        int lastRecordExtraSize = totalSize % numRecords;
        for (int i = 0; i < numRecords - 1; ++i) {
            this.writeRecord(minRecordSize, delimiter);
        }
        this.writeRecord(minRecordSize + lastRecordExtraSize, delimiter);
    }

    public void writeRecord(int totalSize, byte[] delimiter) throws IOException {
        Preconditions.checkArgument((delimiter.length > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((totalSize >= delimiter.length ? 1 : 0) != 0);
        int contentSize = totalSize - delimiter.length;
        for (int i = 0; i < contentSize; ++i) {
            this.out.write(i % 2 == 0 ? 97 : 98);
        }
        this.write(delimiter);
    }

    public void write(String bytes) throws IOException {
        this.write(bytes.getBytes(StandardCharsets.UTF_8));
    }

    public void write(byte[] bytes) throws IOException {
        this.out.write(bytes);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

