/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server.auth;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.auth.IPAuthenticationProvider;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.auth.ServerAuthenticationProvider;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.auth.WrappedAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderRegistry.class);
    public static final String AUTHPROVIDER_PROPERTY_PREFIX = "zookeeper.authProvider.";
    private static boolean initialized = false;
    private static final Map<String, AuthenticationProvider> authenticationProviders = new HashMap<String, AuthenticationProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Class<ProviderRegistry> clazz = ProviderRegistry.class;
        synchronized (ProviderRegistry.class) {
            initialized = false;
            authenticationProviders.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Class<ProviderRegistry> clazz = ProviderRegistry.class;
        synchronized (ProviderRegistry.class) {
            IPAuthenticationProvider ipp = new IPAuthenticationProvider();
            authenticationProviders.put(ipp.getScheme(), ipp);
            if (DigestAuthenticationProvider.isEnabled()) {
                DigestAuthenticationProvider digp = new DigestAuthenticationProvider();
                authenticationProviders.put(digp.getScheme(), digp);
            }
            Enumeration<Object> en = System.getProperties().keys();
            while (en.hasMoreElements()) {
                String k = (String)en.nextElement();
                if (!k.startsWith(AUTHPROVIDER_PROPERTY_PREFIX)) continue;
                String className = System.getProperty(k);
                try {
                    Class<?> c = ZooKeeperServer.class.getClassLoader().loadClass(className);
                    AuthenticationProvider ap = (AuthenticationProvider)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    authenticationProviders.put(ap.getScheme(), ap);
                }
                catch (Exception e) {
                    LOG.warn("Problems loading {}", (Object)className, (Object)e);
                }
            }
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static ServerAuthenticationProvider getServerProvider(String scheme) {
        return WrappedAuthenticationProvider.wrap(ProviderRegistry.getProvider(scheme));
    }

    public static AuthenticationProvider getProvider(String scheme) {
        if (!initialized) {
            ProviderRegistry.initialize();
        }
        return authenticationProviders.get(scheme);
    }

    public static void removeProvider(String scheme) {
        authenticationProviders.remove(scheme);
    }

    public static String listProviders() {
        StringBuilder sb = new StringBuilder();
        for (String s : authenticationProviders.keySet()) {
            sb.append(s).append(" ");
        }
        return sb.toString();
    }
}

