/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.scheduler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.DistributedSchedulingAllocateRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DistributedSchedulingAllocateResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterDistributedSchedulingAMResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoteNode;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyApplicationContext;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AbstractRequestInterceptor;
import org.apache.hadoop.yarn.server.nodemanager.security.NMTokenSecretManagerInNM;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerAllocator;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DistributedScheduler
extends AbstractRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedScheduler.class);
    private static final RecordFactory RECORD_FACTORY = RecordFactoryProvider.getRecordFactory(null);
    private OpportunisticContainerContext oppContainerContext = new OpportunisticContainerContext();
    private Map<NodeId, NMToken> nodeTokens = new HashMap<NodeId, NMToken>();
    private ApplicationAttemptId applicationAttemptId;
    private OpportunisticContainerAllocator containerAllocator;
    private NMTokenSecretManagerInNM nmSecretManager;
    private String appSubmitter;
    private long rmIdentifier;

    @Override
    public void init(AMRMProxyApplicationContext applicationContext) {
        super.init(applicationContext);
        this.initLocal(applicationContext.getNMContext().getNodeStatusUpdater().getRMIdentifier(), applicationContext.getApplicationAttemptId(), applicationContext.getNMContext().getContainerAllocator(), applicationContext.getNMContext().getNMTokenSecretManager(), applicationContext.getUser());
    }

    @VisibleForTesting
    void initLocal(long rmId, ApplicationAttemptId appAttemptId, OpportunisticContainerAllocator oppContainerAllocator, NMTokenSecretManagerInNM nmSecretManager, String appSubmitter) {
        this.rmIdentifier = rmId;
        this.applicationAttemptId = appAttemptId;
        this.containerAllocator = oppContainerAllocator;
        this.nmSecretManager = nmSecretManager;
        this.appSubmitter = appSubmitter;
        this.oppContainerContext.setContainerIdGenerator(new OpportunisticContainerAllocator.ContainerIdGenerator(){

            @Override
            public long generateContainerId() {
                return this.containerIdCounter.decrementAndGet();
            }
        });
    }

    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        return this.registerApplicationMasterForDistributedScheduling(request).getRegisterResponse();
    }

    public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
        DistributedSchedulingAllocateRequest distRequest = (DistributedSchedulingAllocateRequest)RECORD_FACTORY.newRecordInstance(DistributedSchedulingAllocateRequest.class);
        distRequest.setAllocateRequest(request);
        return this.allocateForDistributedScheduling(distRequest).getAllocateResponse();
    }

    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        return this.getNextInterceptor().finishApplicationMaster(request);
    }

    private void updateAllocateResponse(AllocateResponse response, List<NMToken> nmTokens, List<Container> allocatedContainers) {
        ArrayList<NMToken> newTokens = new ArrayList<NMToken>();
        if (allocatedContainers.size() > 0) {
            response.getAllocatedContainers().addAll(allocatedContainers);
            for (Container alloc : allocatedContainers) {
                if (this.nodeTokens.containsKey(alloc.getNodeId())) continue;
                newTokens.add(this.nmSecretManager.generateNMToken(this.appSubmitter, alloc));
            }
            ArrayList<NMToken> retTokens = new ArrayList<NMToken>(nmTokens);
            retTokens.addAll(newTokens);
            response.setNMTokens(retTokens);
        }
    }

    private void updateParameters(RegisterDistributedSchedulingAMResponse registerResponse) {
        Resource incrementResource = registerResponse.getIncrContainerResource();
        if (incrementResource == null) {
            incrementResource = registerResponse.getMinContainerResource();
        }
        this.oppContainerContext.updateAllocationParams(registerResponse.getMinContainerResource(), registerResponse.getMaxContainerResource(), incrementResource, registerResponse.getContainerTokenExpiryInterval());
        this.oppContainerContext.getContainerIdGenerator().resetContainerIdCounter(registerResponse.getContainerIdStart());
        this.setNodeList(registerResponse.getNodesForScheduling());
    }

    private void setNodeList(List<RemoteNode> nodeList) {
        this.oppContainerContext.updateNodeList(nodeList);
    }

    @Override
    public RegisterDistributedSchedulingAMResponse registerApplicationMasterForDistributedScheduling(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        LOG.info("Forwarding registration request to theDistributed Scheduler Service on YARN RM");
        RegisterDistributedSchedulingAMResponse dsResp = this.getNextInterceptor().registerApplicationMasterForDistributedScheduling(request);
        this.updateParameters(dsResp);
        return dsResp;
    }

    @Override
    public DistributedSchedulingAllocateResponse allocateForDistributedScheduling(DistributedSchedulingAllocateRequest request) throws YarnException, IOException {
        OpportunisticContainerAllocator.PartitionedResourceRequests partitionedAsks = this.containerAllocator.partitionAskList(request.getAllocateRequest().getAskList());
        List<Container> allocatedContainers = this.containerAllocator.allocateContainers(request.getAllocateRequest().getResourceBlacklistRequest(), partitionedAsks.getOpportunistic(), this.applicationAttemptId, this.oppContainerContext, this.rmIdentifier, this.appSubmitter);
        request.setAllocatedContainers(allocatedContainers);
        request.getAllocateRequest().setAskList(partitionedAsks.getGuaranteed());
        LOG.debug("Forwarding allocate request to theDistributed Scheduler Service on YARN RM");
        DistributedSchedulingAllocateResponse dsResp = this.getNextInterceptor().allocateForDistributedScheduling(request);
        this.setNodeList(dsResp.getNodesForScheduling());
        List nmTokens = dsResp.getAllocateResponse().getNMTokens();
        for (NMToken nmToken : nmTokens) {
            this.nodeTokens.put(nmToken.getNodeId(), nmToken);
        }
        this.updateAllocateResponse(dsResp.getAllocateResponse(), nmTokens, allocatedContainers);
        return dsResp;
    }
}

