/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;

public final class OfflineAggregationInfo {
    @VisibleForTesting
    public static final String FLOW_AGGREGATION_TABLE_NAME = "yarn_timeline_flow_aggregation";
    public static final String USER_AGGREGATION_TABLE_NAME = "yarn_timeline_user_aggregation";
    private static final String[] FLOW_AGGREGATION_PK_LIST = new String[]{"user", "cluster", "flow_name"};
    private static final String[] USER_AGGREGATION_PK_LIST = new String[]{"user", "cluster"};
    private final String tableName;
    private final String[] primaryKeyList;
    private final PrimaryKeyStringSetter primaryKeyStringSetter;
    public static final OfflineAggregationInfo FLOW_AGGREGATION = new OfflineAggregationInfo("yarn_timeline_flow_aggregation", FLOW_AGGREGATION_PK_LIST, new PrimaryKeyStringSetter(){

        @Override
        public int setValues(PreparedStatement ps, TimelineCollectorContext context, String[] extraInfo, int startPos) throws SQLException {
            int idx = startPos;
            ps.setString(idx++, context.getUserId());
            ps.setString(idx++, context.getClusterId());
            ps.setString(idx++, context.getFlowName());
            return idx;
        }
    });
    public static final OfflineAggregationInfo USER_AGGREGATION = new OfflineAggregationInfo("yarn_timeline_user_aggregation", USER_AGGREGATION_PK_LIST, new PrimaryKeyStringSetter(){

        @Override
        public int setValues(PreparedStatement ps, TimelineCollectorContext context, String[] extraInfo, int startPos) throws SQLException {
            int idx = startPos;
            ps.setString(idx++, context.getUserId());
            ps.setString(idx++, context.getClusterId());
            return idx;
        }
    });

    private OfflineAggregationInfo(String table, String[] pkList, PrimaryKeyStringSetter formatter) {
        this.tableName = table;
        this.primaryKeyList = pkList;
        this.primaryKeyStringSetter = formatter;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String[] getPrimaryKeyList() {
        return (String[])this.primaryKeyList.clone();
    }

    public int setStringsForPrimaryKey(PreparedStatement ps, TimelineCollectorContext context, String[] extraInfo, int startPos) throws SQLException {
        return this.primaryKeyStringSetter.setValues(ps, context, extraInfo, startPos);
    }

    private static interface PrimaryKeyStringSetter {
        public int setValues(PreparedStatement var1, TimelineCollectorContext var2, String[] var3, int var4) throws SQLException;
    }
}

