/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class QueueMapping {
    private MappingType type;
    private String source;
    private String queue;
    private String parentQueue;
    private String fullPath;
    private static final String DELIMITER = ":";

    private QueueMapping(QueueMappingBuilder builder) {
        this.type = builder.type;
        this.source = builder.source;
        this.queue = builder.queue;
        this.parentQueue = builder.parentQueue;
        this.fullPath = this.parentQueue != null ? this.parentQueue + "." + this.queue : this.queue;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getParentQueue() {
        return this.parentQueue;
    }

    public boolean hasParentQueue() {
        return this.parentQueue != null;
    }

    public MappingType getType() {
        return this.type;
    }

    public String getSource() {
        return this.source;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parentQueue == null ? 0 : this.parentQueue.hashCode());
        result = 31 * result + (this.queue == null ? 0 : this.queue.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueueMapping other = (QueueMapping)obj;
        if (this.parentQueue == null ? other.parentQueue != null : !this.parentQueue.equals(other.parentQueue)) {
            return false;
        }
        if (this.queue == null ? other.queue != null : !this.queue.equals(other.queue)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return this.type.toString() + DELIMITER + this.source + DELIMITER + (this.parentQueue != null ? this.parentQueue + "." + this.queue : this.queue);
    }

    public String toTypelessString() {
        return this.source + DELIMITER + (this.parentQueue != null ? this.parentQueue + "." + this.queue : this.queue);
    }

    public static enum MappingType {
        USER("u"),
        GROUP("g"),
        APPLICATION("a");

        private final String type;

        private MappingType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }

    public static class QueueMappingBuilder {
        private MappingType type;
        private String source;
        private String queue;
        private String parentQueue;

        public static QueueMappingBuilder create() {
            return new QueueMappingBuilder();
        }

        public QueueMappingBuilder type(MappingType mappingType) {
            this.type = mappingType;
            return this;
        }

        public QueueMappingBuilder source(String mappingSource) {
            this.source = mappingSource;
            return this;
        }

        public QueueMappingBuilder queue(String mappingQueue) {
            this.queue = mappingQueue;
            return this;
        }

        public QueueMappingBuilder parentQueue(String mappingParentQueue) {
            this.parentQueue = mappingParentQueue;
            return this;
        }

        public QueueMappingBuilder parsePathString(String queuePath) {
            int parentQueueNameEndIndex = queuePath.lastIndexOf(".");
            if (parentQueueNameEndIndex > -1) {
                String parentQueue = queuePath.substring(0, parentQueueNameEndIndex).trim();
                String leafQueue = queuePath.substring(parentQueueNameEndIndex + 1).trim();
                return this.parentQueue(parentQueue).queue(leafQueue);
            }
            return this.queue(queuePath);
        }

        public QueueMapping build() {
            return new QueueMapping(this);
        }
    }
}

