/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.hadoop.cli.CLITestCmdDFS;
import org.apache.hadoop.cli.util.CLICommandDFSAdmin;
import org.apache.hadoop.cli.util.CommandExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.util.Shell;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStorageRestore {
    public static final String NAME_NODE_HOST = "localhost:";
    public static final String NAME_NODE_HTTP_HOST = "0.0.0.0:";
    private static final Logger LOG = LoggerFactory.getLogger((String)TestStorageRestore.class.getName());
    private Configuration config;
    private File hdfsDir = null;
    static final long seed = 0xAAAAEEFL;
    static final int blockSize = 4096;
    static final int fileSize = 8192;
    private File path1;
    private File path2;
    private File path3;
    private MiniDFSCluster cluster;

    @Before
    public void setUpNameDirs() throws Exception {
        this.config = new HdfsConfiguration();
        this.hdfsDir = new File(MiniDFSCluster.getBaseDirectory()).getCanonicalFile();
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete hdfs directory '" + this.hdfsDir + "'");
        }
        this.hdfsDir.mkdirs();
        this.path1 = new File(this.hdfsDir, "name1");
        this.path2 = new File(this.hdfsDir, "name2");
        this.path3 = new File(this.hdfsDir, "name3");
        this.path1.mkdir();
        this.path2.mkdir();
        this.path3.mkdir();
        if (!(this.path2.exists() && this.path3.exists() && this.path1.exists())) {
            throw new IOException("Couldn't create dfs.name dirs in " + this.hdfsDir.getAbsolutePath());
        }
        String dfs_name_dir = new String(this.path1.getPath() + "," + this.path2.getPath());
        System.out.println("configuring hdfsdir is " + this.hdfsDir.getAbsolutePath() + "; dfs_name_dir = " + dfs_name_dir + ";dfs_name_edits_dir(only)=" + this.path3.getPath());
        this.config.set("dfs.namenode.name.dir", dfs_name_dir);
        this.config.set("dfs.namenode.edits.dir", dfs_name_dir + "," + this.path3.getPath());
        this.config.set("dfs.namenode.checkpoint.dir", new File(this.hdfsDir, "secondary").getPath());
        FileSystem.setDefaultUri((Configuration)this.config, (String)"hdfs://localhost:0");
        this.config.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
        this.config.setBoolean("dfs.namenode.name.dir.restore", true);
    }

    public void invalidateStorage(FSImage fi, Set<File> filesToInvalidate) throws IOException {
        ArrayList<Storage.StorageDirectory> al = new ArrayList<Storage.StorageDirectory>(2);
        Iterator it = fi.getStorage().dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = (Storage.StorageDirectory)it.next();
            if (!filesToInvalidate.contains(sd.getRoot())) continue;
            LOG.info("causing IO error on " + sd.getRoot());
            al.add(sd);
        }
        fi.getStorage().reportErrorsOnDirectories(al);
        for (JournalSet.JournalAndStream j : fi.getEditLog().getJournals()) {
            FileJournalManager fm;
            if (!(j.getManager() instanceof FileJournalManager) || !(fm = (FileJournalManager)j.getManager()).getStorageDirectory().getRoot().equals(this.path2) && !fm.getStorageDirectory().getRoot().equals(this.path3)) continue;
            EditLogOutputStream mockStream = (EditLogOutputStream)Mockito.spy((Object)j.getCurrentStream());
            j.setCurrentStreamForTests(mockStream);
            ((EditLogOutputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Injected fault: write")}).when((Object)mockStream)).write((FSEditLogOp)ArgumentMatchers.any());
        }
    }

    private void printStorages(FSImage image) {
        FSImageTestUtil.logStorageContents(LOG, image.getStorage());
    }

    @Test
    public void testStorageRestore() throws Exception {
        int numDatanodes = 0;
        this.cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(numDatanodes).manageNameDfsDirs(false).build();
        this.cluster.waitActive();
        SecondaryNameNode secondary = new SecondaryNameNode(this.config);
        System.out.println("****testStorageRestore: Cluster and SNN started");
        this.printStorages(this.cluster.getNameNode().getFSImage());
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Path path = new Path("/", "test");
        Assert.assertTrue((boolean)fs.mkdirs(path));
        System.out.println("****testStorageRestore: dir 'test' created, invalidating storage...");
        this.invalidateStorage(this.cluster.getNameNode().getFSImage(), (Set<File>)ImmutableSet.of((Object)this.path2, (Object)this.path3));
        this.printStorages(this.cluster.getNameNode().getFSImage());
        System.out.println("****testStorageRestore: storage invalidated");
        path = new Path("/", "test1");
        Assert.assertTrue((boolean)fs.mkdirs(path));
        System.out.println("****testStorageRestore: dir 'test1' created");
        FSImageTestUtil.assertFileContentsDifferent(2, new File(this.path1, "current/" + NNStorage.getInProgressEditsFileName((long)1L)), new File(this.path2, "current/" + NNStorage.getInProgressEditsFileName((long)1L)), new File(this.path3, "current/" + NNStorage.getInProgressEditsFileName((long)1L)));
        FSImageTestUtil.assertFileContentsSame(new File(this.path2, "current/" + NNStorage.getInProgressEditsFileName((long)1L)), new File(this.path3, "current/" + NNStorage.getInProgressEditsFileName((long)1L)));
        System.out.println("****testStorageRestore: checkfiles(false) run");
        secondary.doCheckpoint();
        FSImageTestUtil.assertFileContentsSame(new File(this.path1, "current/" + NNStorage.getImageFileName((long)4L)), new File(this.path2, "current/" + NNStorage.getImageFileName((long)4L)));
        Assert.assertFalse((String)"Should not have any image in an edits-only directory", (boolean)new File(this.path3, "current/" + NNStorage.getImageFileName((long)4L)).exists());
        Assert.assertTrue((String)"Should have finalized logs in the directory that didn't fail", (boolean)new File(this.path1, "current/" + NNStorage.getFinalizedEditsFileName((long)1L, (long)4L)).exists());
        Assert.assertFalse((String)"Should not have finalized logs in the failed directories", (boolean)new File(this.path2, "current/" + NNStorage.getFinalizedEditsFileName((long)1L, (long)4L)).exists());
        Assert.assertFalse((String)"Should not have finalized logs in the failed directories", (boolean)new File(this.path3, "current/" + NNStorage.getFinalizedEditsFileName((long)1L, (long)4L)).exists());
        FSImageTestUtil.assertFileContentsSame(new File(this.path1, "current/" + NNStorage.getInProgressEditsFileName((long)5L)), new File(this.path2, "current/" + NNStorage.getInProgressEditsFileName((long)5L)), new File(this.path3, "current/" + NNStorage.getInProgressEditsFileName((long)5L)));
        String md5BeforeEdit = FSImageTestUtil.getFileMD5(new File(this.path1, "current/" + NNStorage.getInProgressEditsFileName((long)5L)));
        FSImageTestUtil.assertFileContentsSame(new File(this.path1, "current/" + NNStorage.getImageFileName((long)0L)), new File(this.path2, "current/" + NNStorage.getImageFileName((long)0L)));
        path = new Path("/", "test2");
        Assert.assertTrue((boolean)fs.mkdirs(path));
        String md5AfterEdit = FSImageTestUtil.getFileMD5(new File(this.path1, "current/" + NNStorage.getInProgressEditsFileName((long)5L)));
        Assert.assertFalse((boolean)md5BeforeEdit.equals(md5AfterEdit));
        FSImageTestUtil.assertFileContentsSame(new File(this.path1, "current/" + NNStorage.getInProgressEditsFileName((long)5L)), new File(this.path2, "current/" + NNStorage.getInProgressEditsFileName((long)5L)), new File(this.path3, "current/" + NNStorage.getInProgressEditsFileName((long)5L)));
        secondary.shutdown();
        this.cluster.shutdown();
        FSImageTestUtil.assertFileContentsSame(new File(this.path1, "current/" + NNStorage.getFinalizedEditsFileName((long)5L, (long)7L)), new File(this.path2, "current/" + NNStorage.getFinalizedEditsFileName((long)5L, (long)7L)), new File(this.path3, "current/" + NNStorage.getFinalizedEditsFileName((long)5L, (long)7L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDfsAdminCmd() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(2).manageNameDfsDirs(false).build();
        this.cluster.waitActive();
        try {
            FSImage fsi = this.cluster.getNameNode().getFSImage();
            boolean restore = fsi.getStorage().getRestoreFailedStorage();
            LOG.info("Restore is " + restore);
            Assert.assertEquals((Object)restore, (Object)true);
            String cmd = "-fs NAMENODE -restoreFailedStorage false";
            String namenode = this.config.get("fs.defaultFS", "file:///");
            CommandExecutor executor = new CLITestCmdDFS(cmd, new CLICommandDFSAdmin()).getExecutor(namenode, this.config);
            executor.executeCommand(cmd);
            restore = fsi.getStorage().getRestoreFailedStorage();
            Assert.assertFalse((String)("After set true call restore is " + restore), (boolean)restore);
            cmd = "-fs NAMENODE -restoreFailedStorage true";
            executor.executeCommand(cmd);
            restore = fsi.getStorage().getRestoreFailedStorage();
            Assert.assertTrue((String)("After set false call restore is " + restore), (boolean)restore);
            cmd = "-fs NAMENODE -restoreFailedStorage check";
            CommandExecutor.Result cmdResult = executor.executeCommand(cmd);
            restore = fsi.getStorage().getRestoreFailedStorage();
            Assert.assertTrue((String)("After check call restore is " + restore), (boolean)restore);
            String commandOutput = cmdResult.getCommandOutput();
            Assert.assertTrue((boolean)commandOutput.contains("restoreFailedStorage is set to true"));
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleSecondaryCheckpoint() throws IOException {
        SecondaryNameNode secondary = null;
        try {
            this.cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(1).manageNameDfsDirs(false).build();
            this.cluster.waitActive();
            secondary = new SecondaryNameNode(this.config);
            FSImage fsImage = this.cluster.getNameNode().getFSImage();
            this.printStorages(fsImage);
            DistributedFileSystem fs = this.cluster.getFileSystem();
            Path testPath = new Path("/", "test");
            Assert.assertTrue((boolean)fs.mkdirs(testPath));
            this.printStorages(fsImage);
            this.invalidateStorage(fsImage, (Set<File>)ImmutableSet.of((Object)this.path1));
            this.cluster.getNameNodeRpc().rollEditLog();
            this.printStorages(fsImage);
            secondary.doCheckpoint();
            this.printStorages(fsImage);
            Assert.assertTrue((String)"path exists before restart", (boolean)fs.exists(testPath));
            secondary.shutdown();
            this.cluster.restartNameNode(new String[0]);
            Assert.assertTrue((String)"path should still exist after restart", (boolean)fs.exists(testPath));
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
            if (secondary != null) {
                secondary.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStorageRestoreFailure() throws Exception {
        SecondaryNameNode secondary = null;
        String nameDir2 = Shell.WINDOWS ? new File(this.path2, "current").getAbsolutePath() : this.path2.toString();
        String nameDir3 = Shell.WINDOWS ? new File(this.path3, "current").getAbsolutePath() : this.path3.toString();
        try {
            this.cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(0).manageNameDfsDirs(false).build();
            this.cluster.waitActive();
            secondary = new SecondaryNameNode(this.config);
            this.printStorages(this.cluster.getNameNode().getFSImage());
            DistributedFileSystem fs = this.cluster.getFileSystem();
            Path path = new Path("/", "test");
            Assert.assertTrue((boolean)fs.mkdirs(path));
            Assert.assertTrue((FileUtil.chmod((String)nameDir2, (String)"000") == 0 ? 1 : 0) != 0);
            Assert.assertTrue((FileUtil.chmod((String)nameDir3, (String)"000") == 0 ? 1 : 0) != 0);
            secondary.doCheckpoint();
            this.printStorages(this.cluster.getNameNode().getFSImage());
            path = new Path("/", "test1");
            Assert.assertTrue((boolean)fs.mkdirs(path));
            assert (this.cluster.getNameNode().getFSImage().getStorage().getNumStorageDirs() == 1);
            secondary.doCheckpoint();
            assert (this.cluster.getNameNode().getFSImage().getStorage().getNumStorageDirs() == 1);
            Assert.assertTrue((FileUtil.chmod((String)nameDir2, (String)"755") == 0 ? 1 : 0) != 0);
            Assert.assertTrue((FileUtil.chmod((String)nameDir3, (String)"755") == 0 ? 1 : 0) != 0);
            secondary.doCheckpoint();
            assert (this.cluster.getNameNode().getFSImage().getStorage().getNumStorageDirs() == 3);
        }
        finally {
            if (this.path2.exists()) {
                FileUtil.chmod((String)nameDir2, (String)"755");
            }
            if (this.path3.exists()) {
                FileUtil.chmod((String)nameDir3, (String)"755");
            }
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
            if (secondary != null) {
                secondary.shutdown();
            }
        }
    }
}

