/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class AbstractContractUnbufferTest
extends AbstractFSContractTestBase {
    private Path file;
    private byte[] fileBytes;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.skipIfUnsupported("supports-unbuffer");
        this.file = this.path("unbufferFile");
        this.fileBytes = ContractTestUtils.dataset(1024, 0, 255);
        ContractTestUtils.createFile(this.getFileSystem(), this.file, true, this.fileBytes);
    }

    @Test
    public void testUnbufferAfterRead() throws IOException {
        this.describe("unbuffer a file after a single read");
        try (FSDataInputStream stream = this.getFileSystem().open(this.file);){
            this.validateFullFileContents(stream);
            this.unbuffer(stream);
        }
    }

    @Test
    public void testUnbufferBeforeRead() throws IOException {
        this.describe("unbuffer a file before a read");
        try (FSDataInputStream stream = this.getFileSystem().open(this.file);){
            this.unbuffer(stream);
            this.validateFullFileContents(stream);
        }
    }

    @Test
    public void testUnbufferEmptyFile() throws IOException {
        Path emptyFile = this.path("emptyUnbufferFile");
        this.getFileSystem().create(emptyFile, true).close();
        this.describe("unbuffer an empty file");
        try (FSDataInputStream stream = this.getFileSystem().open(emptyFile);){
            this.unbuffer(stream);
        }
    }

    @Test
    public void testUnbufferOnClosedFile() throws IOException {
        this.describe("unbuffer a file before a read");
        try (FSDataInputStream stream = null;){
            stream = this.getFileSystem().open(this.file);
            this.validateFullFileContents(stream);
        }
        if (stream != null) {
            this.unbuffer(stream);
        }
    }

    @Test
    public void testMultipleUnbuffers() throws IOException {
        this.describe("unbuffer a file multiple times");
        try (FSDataInputStream stream = this.getFileSystem().open(this.file);){
            this.unbuffer(stream);
            this.unbuffer(stream);
            this.validateFullFileContents(stream);
            this.unbuffer(stream);
            this.unbuffer(stream);
        }
    }

    @Test
    public void testUnbufferMultipleReads() throws IOException {
        this.describe("unbuffer a file multiple times");
        try (FSDataInputStream stream = this.getFileSystem().open(this.file);){
            this.unbuffer(stream);
            this.validateFileContents(stream, 128, 0);
            this.unbuffer(stream);
            this.validateFileContents(stream, 128, 128);
            this.validateFileContents(stream, 256, 256);
            this.unbuffer(stream);
            this.validateFileContents(stream, 512, 512);
            this.unbuffer(stream);
            AbstractContractUnbufferTest.assertEquals((String)"stream should be at end of file", (long)1024L, (long)stream.getPos());
        }
    }

    private void unbuffer(FSDataInputStream stream) throws IOException {
        long pos = stream.getPos();
        stream.unbuffer();
        AbstractContractUnbufferTest.assertEquals((String)"unbuffer unexpectedly changed the stream position", (long)pos, (long)stream.getPos());
    }

    protected void validateFullFileContents(FSDataInputStream stream) throws IOException {
        this.validateFileContents(stream, 1024, 0);
    }

    protected void validateFileContents(FSDataInputStream stream, int length, int startIndex) throws IOException {
        byte[] streamData = new byte[length];
        int read = ContractTestUtils.readNBytes((InputStream)stream, streamData, 0, length);
        ((AbstractIntegerAssert)Assertions.assertThat((int)read).describedAs("failed to read expected number of bytes from stream. %s", new Object[]{stream})).isEqualTo(length);
        byte[] validateFileBytes = startIndex == 0 && length == this.fileBytes.length ? this.fileBytes : Arrays.copyOfRange(this.fileBytes, startIndex, startIndex + length);
        AbstractContractUnbufferTest.assertArrayEquals((String)"invalid file contents", (byte[])validateFileBytes, (byte[])streamData);
    }

    protected Path getFile() {
        return this.file;
    }
}

