/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppController;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsAboutPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsAttemptsPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsConfPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsCountersPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsJobPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsLogsPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsSingleCounterPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsTaskPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsTasksPage;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.log.AggregatedLogsPage;

public class HsController
extends AppController {
    @Inject
    HsController(App app, Configuration conf, Controller.RequestContext ctx) {
        super(app, conf, ctx, "History");
    }

    public void index() {
        this.setTitle("JobHistory");
    }

    protected Class<? extends View> jobPage() {
        return HsJobPage.class;
    }

    public Class<? extends View> countersPage() {
        return HsCountersPage.class;
    }

    protected Class<? extends View> tasksPage() {
        return HsTasksPage.class;
    }

    protected Class<? extends View> taskPage() {
        return HsTaskPage.class;
    }

    protected Class<? extends View> attemptsPage() {
        return HsAttemptsPage.class;
    }

    public void job() {
        super.job();
    }

    public void jobCounters() {
        super.jobCounters();
    }

    public void taskCounters() {
        super.taskCounters();
    }

    public void tasks() {
        super.tasks();
    }

    public void task() {
        super.task();
    }

    public void attempts() {
        super.attempts();
    }

    protected Class<? extends View> confPage() {
        return HsConfPage.class;
    }

    protected Class<? extends View> aboutPage() {
        return HsAboutPage.class;
    }

    public void about() {
        this.render(this.aboutPage());
    }

    public void logs() {
        String logEntity = this.$("entity.string");
        JobID jid = null;
        try {
            jid = JobID.forName((String)logEntity);
            this.set("job.id", logEntity);
            this.requireJob();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jid == null) {
            try {
                TaskAttemptID taskAttemptId = TaskAttemptID.forName((String)logEntity);
                this.set("task.id", taskAttemptId.getTaskID().toString());
                this.set("job.id", taskAttemptId.getJobID().toString());
                this.requireTask();
                this.requireJob();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.render(HsLogsPage.class);
    }

    public void nmlogs() {
        this.render(AggregatedLogsPage.class);
    }

    protected Class<? extends View> singleCounterPage() {
        return HsSingleCounterPage.class;
    }

    public void singleJobCounter() throws IOException {
        super.singleJobCounter();
    }

    public void singleTaskCounter() throws IOException {
        super.singleTaskCounter();
    }
}

