/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class BadRequestException
extends DocumentClientException {
    private static final long serialVersionUID = 1L;

    public BadRequestException(String message, Exception innerException) {
        super(message, innerException, new HashMap<String, String>(), 400, null);
    }

    public BadRequestException() {
        this("One of the input values is invalid.");
    }

    public BadRequestException(Error error, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(400, error, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    public BadRequestException(String message) {
        this(message, null, (HttpResponseHeaders)null, null);
    }

    public BadRequestException(String message, HttpResponseHeaders headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    public BadRequestException(String message, HttpResponseHeaders headers, URI requestUri) {
        this(message, headers, requestUri != null ? requestUri.toString() : null);
    }

    public BadRequestException(Exception innerException) {
        this("One of the input values is invalid.", innerException, null, null);
    }

    public BadRequestException(String message, Exception innerException, HttpResponseHeaders headers, String requestUri) {
        super(String.format("%s: %s", "One of the input values is invalid.", message), innerException, HttpUtils.asMap(headers), 400, requestUri != null ? requestUri.toString() : null);
    }
}

