/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.attributes;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.shaded.org.glassfish.grizzly.attributes.Attribute;
import org.apache.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeBuilder;
import org.apache.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeHolder;
import org.apache.hadoop.shaded.org.glassfish.grizzly.attributes.DefaultAttributeBuilder;
import org.apache.hadoop.shaded.org.glassfish.grizzly.attributes.IndexedAttributeAccessor;

public class NamedAttributeHolder
implements AttributeHolder {
    protected final Map<String, Object> attributesMap;
    protected final DefaultAttributeBuilder attributeBuilder;

    public NamedAttributeHolder(AttributeBuilder attributeBuilder) {
        this.attributeBuilder = (DefaultAttributeBuilder)attributeBuilder;
        this.attributesMap = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributesMap.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute == null) {
            this.attributeBuilder.createAttribute(name);
        }
        this.attributesMap.put(name, value);
    }

    @Override
    public Object removeAttribute(String name) {
        return this.attributesMap.remove(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributesMap.keySet();
    }

    @Override
    public void recycle() {
        this.attributesMap.clear();
    }

    @Override
    public void clear() {
        this.attributesMap.clear();
    }

    @Override
    public AttributeBuilder getAttributeBuilder() {
        return this.attributeBuilder;
    }

    @Override
    public IndexedAttributeAccessor getIndexedAttributeAccessor() {
        return null;
    }
}

