/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.Abortable;

public class SDKStreamDrainer<TStream extends InputStream>
implements CallableRaisingIOE<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(SDKStreamDrainer.class);
    private final String uri;
    private final TStream sdkStream;
    private final boolean shouldAbort;
    private int remaining;
    private final S3AInputStreamStatistics streamStatistics;
    private final String reason;
    private final AtomicBoolean executed = new AtomicBoolean(false);
    private Exception thrown;
    private boolean aborted;
    private int drained = 0;

    public SDKStreamDrainer(String uri, TStream sdkStream, boolean shouldAbort, int remaining, S3AInputStreamStatistics streamStatistics, String reason) {
        this.uri = uri;
        this.sdkStream = (InputStream)Objects.requireNonNull(sdkStream);
        this.shouldAbort = shouldAbort;
        this.remaining = remaining;
        this.streamStatistics = Objects.requireNonNull(streamStatistics);
        this.reason = reason;
    }

    public Boolean apply() {
        try {
            Boolean outcome = (Boolean)IOStatisticsBinding.invokeTrackingDuration((DurationTracker)this.streamStatistics.initiateInnerStreamClose(this.shouldAbort), this::drainOrAbortHttpStream);
            this.aborted = outcome;
            return outcome;
        }
        catch (Exception e) {
            this.thrown = e;
            return this.aborted;
        }
    }

    @VisibleForTesting
    boolean applyRaisingException() throws Exception {
        Boolean outcome = this.apply();
        if (this.thrown != null) {
            throw this.thrown;
        }
        return outcome;
    }

    private boolean drainOrAbortHttpStream() {
        if (this.executed.getAndSet(true)) {
            throw new IllegalStateException("duplicate invocation of drain operation");
        }
        boolean executeAbort = this.shouldAbort;
        if (this.remaining > 0 || executeAbort) {
            LOG.debug("drain or abort reason {} remaining={} abort={}", new Object[]{this.reason, this.remaining, executeAbort});
        }
        if (!executeAbort) {
            try {
                if (this.remaining > 0) {
                    LOG.debug("draining {} bytes", (Object)this.remaining);
                    this.drained = 0;
                    int size = Math.min(this.remaining, 16384);
                    byte[] buffer = new byte[size];
                    while (this.remaining > 0) {
                        int count = ((InputStream)this.sdkStream).read(buffer);
                        LOG.debug("read {} bytes", (Object)count);
                        if (count <= 0) break;
                        this.drained += count;
                        this.remaining -= count;
                    }
                    LOG.debug("Drained stream of {} bytes", (Object)this.drained);
                }
                if (this.remaining != 0) {
                    LOG.debug("drained fewer bytes than expected; {} remaining", (Object)this.remaining);
                }
                LOG.debug("Closing stream");
                ((InputStream)this.sdkStream).close();
                this.streamStatistics.streamClose(false, this.drained);
                return false;
            }
            catch (Exception e) {
                LOG.debug("When closing {} stream for {}, will abort the stream", new Object[]{this.uri, this.reason, e});
                this.thrown = e;
            }
        }
        LOG.debug("Aborting stream {}", (Object)this.uri);
        try {
            ((Abortable)this.sdkStream).abort();
        }
        catch (Exception e) {
            LOG.warn("When aborting {} stream after failing to close it for {}", new Object[]{this.uri, this.reason, e});
            this.thrown = e;
        }
        this.streamStatistics.streamClose(true, this.remaining);
        LOG.debug("Stream {} aborted: {}; remaining={}", new Object[]{this.uri, this.reason, this.remaining});
        return true;
    }

    public String getUri() {
        return this.uri;
    }

    public TStream getSdkStream() {
        return this.sdkStream;
    }

    public boolean shouldAbort() {
        return this.shouldAbort;
    }

    public int getRemaining() {
        return this.remaining;
    }

    public S3AInputStreamStatistics getStreamStatistics() {
        return this.streamStatistics;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean executed() {
        return this.executed.get();
    }

    public Exception getThrown() {
        return this.thrown;
    }

    public int getDrained() {
        return this.drained;
    }

    public boolean aborted() {
        return this.aborted;
    }

    public String toString() {
        return "SDKStreamDrainer{uri='" + this.uri + '\'' + ", reason='" + this.reason + '\'' + ", shouldAbort=" + this.shouldAbort + ", remaining=" + this.remaining + ", executed=" + this.executed.get() + ", aborted=" + this.aborted + ", inner=" + this.sdkStream + ", thrown=" + this.thrown + '}';
    }
}

