/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorBaseDescriptor;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorJob;
import org.apache.hadoop.util.ExitUtil;

public class AggregateWordCount {
    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = ValueAggregatorJob.createValueAggregatorJob((String[])args, (Class[])new Class[]{WordCountPlugInClass.class});
        job.setJarByClass(AggregateWordCount.class);
        int ret = job.waitForCompletion(true) ? 0 : 1;
        ExitUtil.terminate((int)ret);
    }

    public static class WordCountPlugInClass
    extends ValueAggregatorBaseDescriptor {
        public ArrayList<Map.Entry<Text, Text>> generateKeyValPairs(Object key, Object val) {
            String countType = "LongValueSum";
            ArrayList<Map.Entry<Text, Text>> retv = new ArrayList<Map.Entry<Text, Text>>();
            String line = val.toString();
            StringTokenizer itr = new StringTokenizer(line);
            while (itr.hasMoreTokens()) {
                Map.Entry e = WordCountPlugInClass.generateEntry((String)countType, (String)itr.nextToken(), (Text)ONE);
                if (e == null) continue;
                retv.add(e);
            }
            return retv;
        }
    }
}

