/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.yarn.api.records.ApplicationId;

public class TimestampGenerator {
    public static final long TS_MULTIPLIER = 1000000L;
    private final AtomicLong lastTimestamp = new AtomicLong();

    public long currentTime() {
        return System.currentTimeMillis() * 1000000L;
    }

    public long getUniqueTimestamp() {
        long nextTs;
        long lastTs;
        while (!this.lastTimestamp.compareAndSet(lastTs = this.lastTimestamp.get(), nextTs = Math.max(lastTs + 1L, this.currentTime()))) {
        }
        return nextTs;
    }

    public static long getSupplementedTimestamp(long incomingTS, String appId) {
        long suffix = TimestampGenerator.getAppIdSuffix(appId);
        long outgoingTS = incomingTS * 1000000L + suffix;
        return outgoingTS;
    }

    private static long getAppIdSuffix(String appIdStr) {
        if (appIdStr == null) {
            return 0L;
        }
        ApplicationId appId = ApplicationId.fromString((String)appIdStr);
        long id = (long)appId.getId() % 1000000L;
        return id;
    }

    public static long getTruncatedTimestamp(long incomingTS) {
        return incomingTS / 1000000L;
    }
}

