/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestTruncatedInputBug {
    private static String TEST_ROOT_DIR = GenericTestUtils.getTestDir().getAbsolutePath();

    private void writeFile(FileSystem fileSys, Path name, int nBytesToWrite) throws IOException {
        FSDataOutputStream out = fileSys.create(name);
        for (int i = 0; i < nBytesToWrite; ++i) {
            out.writeByte(0);
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncatedInputBug() throws IOException {
        int ioBufSize = 512;
        int fileSize = 2048;
        int filePos = 0;
        Configuration conf = new Configuration();
        conf.setInt("io.file.buffer.size", 512);
        LocalFileSystem fileSys = FileSystem.getLocal((Configuration)conf);
        try {
            Path testFile = new Path(TEST_ROOT_DIR, "HADOOP-1489");
            this.writeFile((FileSystem)fileSys, testFile, 2048);
            Assert.assertTrue((boolean)fileSys.exists(testFile));
            Assert.assertTrue((fileSys.getFileStatus(testFile).getLen() == 2048L ? 1 : 0) != 0);
            FSDataInputStream in = fileSys.open(testFile, 512);
            in.seek((long)(filePos += 1526));
            for (int i = 0; i < 4 && in.read() != -1; ++i) {
                ++filePos;
            }
            in.mark(1);
            System.out.println("MARKED");
            while (filePos < 2048 && in.read() != -1) {
                ++filePos;
            }
            in.close();
            System.out.println("Read " + filePos + " bytes. file size=" + 2048);
            Assert.assertTrue((filePos == 2048 ? 1 : 0) != 0);
        }
        finally {
            try {
                fileSys.close();
            }
            catch (Exception exception) {}
        }
    }
}

