/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.util;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ReadWriteBuffer {
    private byte[] _buff;
    private int _writePoint;
    private int _readPoint;
    static final int CACHE_LINE_SIZE = 16;

    public ReadWriteBuffer(int length) {
        if (length > 0) {
            this._buff = new byte[length];
        }
    }

    public ReadWriteBuffer() {
        this._buff = new byte[16];
    }

    public ReadWriteBuffer(byte[] bytes) {
        this._buff = bytes;
        this._writePoint = 0;
        this._readPoint = 0;
    }

    public void reset(byte[] newBuff) {
        this._buff = newBuff;
        this._writePoint = 0;
        this._readPoint = 0;
    }

    public void setReadPoint(int pos) {
        this._readPoint = pos;
    }

    public void setWritePoint(int pos) {
        this._writePoint = pos;
    }

    public byte[] getBuff() {
        return this._buff;
    }

    public int getWritePoint() {
        return this._writePoint;
    }

    public int getReadPoint() {
        return this._readPoint;
    }

    public void writeInt(int v) {
        this.checkWriteSpaceAndResizeIfNecessary(4);
        this._buff[this._writePoint + 0] = (byte)(v >>> 0 & 0xFF);
        this._buff[this._writePoint + 1] = (byte)(v >>> 8 & 0xFF);
        this._buff[this._writePoint + 2] = (byte)(v >>> 16 & 0xFF);
        this._buff[this._writePoint + 3] = (byte)(v >>> 24 & 0xFF);
        this._writePoint += 4;
    }

    public void writeLong(long v) {
        this.checkWriteSpaceAndResizeIfNecessary(8);
        this._buff[this._writePoint + 0] = (byte)(v >>> 0);
        this._buff[this._writePoint + 1] = (byte)(v >>> 8);
        this._buff[this._writePoint + 2] = (byte)(v >>> 16);
        this._buff[this._writePoint + 3] = (byte)(v >>> 24);
        this._buff[this._writePoint + 4] = (byte)(v >>> 32);
        this._buff[this._writePoint + 5] = (byte)(v >>> 40);
        this._buff[this._writePoint + 6] = (byte)(v >>> 48);
        this._buff[this._writePoint + 7] = (byte)(v >>> 56);
        this._writePoint += 8;
    }

    public void writeBytes(byte[] b, int off, int len) {
        this.writeInt(len);
        this.checkWriteSpaceAndResizeIfNecessary(len);
        System.arraycopy(b, off, this._buff, this._writePoint, len);
        this._writePoint += len;
    }

    public int readInt() {
        int ch4 = 0xFF & this._buff[this._readPoint + 0];
        int ch3 = 0xFF & this._buff[this._readPoint + 1];
        int ch2 = 0xFF & this._buff[this._readPoint + 2];
        int ch1 = 0xFF & this._buff[this._readPoint + 3];
        this._readPoint += 4;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() {
        long result = (long)(((this._buff[this._readPoint + 0] & 0xFF) << 0) + ((this._buff[this._readPoint + 1] & 0xFF) << 8) + ((this._buff[this._readPoint + 2] & 0xFF) << 16)) + ((long)(this._buff[this._readPoint + 3] & 0xFF) << 24) + ((long)(this._buff[this._readPoint + 4] & 0xFF) << 32) + ((long)(this._buff[this._readPoint + 5] & 0xFF) << 40) + ((long)(this._buff[this._readPoint + 6] & 0xFF) << 48) + ((long)this._buff[this._readPoint + 7] << 56);
        this._readPoint += 8;
        return result;
    }

    public byte[] readBytes() {
        int length = this.readInt();
        byte[] result = new byte[length];
        System.arraycopy(this._buff, this._readPoint, result, 0, length);
        this._readPoint += length;
        return result;
    }

    public void writeString(String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        this.writeBytes(bytes, 0, bytes.length);
    }

    public String readString() {
        byte[] bytes = this.readBytes();
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private void checkWriteSpaceAndResizeIfNecessary(int toBeWritten) {
        if (this._buff.length - this._writePoint >= toBeWritten) {
            return;
        }
        int newLength = toBeWritten + this._writePoint > 16 ? toBeWritten + this._writePoint : 16;
        byte[] newBuff = new byte[newLength];
        System.arraycopy(this._buff, 0, newBuff, 0, this._writePoint);
        this._buff = newBuff;
    }
}

