/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.constants.AbfsHttpConstants;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsDriverException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsInvalidChecksumException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.ConcurrentWriteOperationDetectedException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidAbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidFileSystemPropertyException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.contracts.services.DfsListResultEntrySchema;
import org.apache.hadoop.fs.azurebfs.contracts.services.DfsListResultSchema;
import org.apache.hadoop.fs.azurebfs.contracts.services.StorageErrorResponseSchema;
import org.apache.hadoop.fs.azurebfs.extensions.EncryptionContextProvider;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientRenameResult;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsUriQueryBuilder;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.ListResponseData;
import org.apache.hadoop.fs.azurebfs.services.SharedKeyCredentials;
import org.apache.hadoop.fs.azurebfs.services.VersionedFileStatus;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.util.StringUtils;

public class AbfsDfsClient
extends AbfsClient {
    public AbfsDfsClient(URL baseUrl, SharedKeyCredentials sharedKeyCredentials, AbfsConfiguration abfsConfiguration, AccessTokenProvider tokenProvider, EncryptionContextProvider encryptionContextProvider, AbfsClientContext abfsClientContext) throws IOException {
        super(baseUrl, sharedKeyCredentials, abfsConfiguration, tokenProvider, encryptionContextProvider, abfsClientContext);
    }

    public AbfsDfsClient(URL baseUrl, SharedKeyCredentials sharedKeyCredentials, AbfsConfiguration abfsConfiguration, SASTokenProvider sasTokenProvider, EncryptionContextProvider encryptionContextProvider, AbfsClientContext abfsClientContext) throws IOException {
        super(baseUrl, sharedKeyCredentials, abfsConfiguration, sasTokenProvider, encryptionContextProvider, abfsClientContext);
    }

    @Override
    public List<AbfsHttpHeader> createDefaultHeaders() {
        return this.createDefaultHeaders(this.getxMsVersion());
    }

    @Override
    public List<AbfsHttpHeader> createDefaultHeaders(AbfsHttpConstants.ApiVersion xMsVersion) {
        List<AbfsHttpHeader> requestHeaders = this.createCommonHeaders(xMsVersion);
        requestHeaders.add(new AbfsHttpHeader("Accept", "application/json, application/octet-stream"));
        return requestHeaders;
    }

    @Override
    public AbfsRestOperation createFilesystem(TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = new AbfsUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("resource", "filesystem");
        URL url = this.createRequestUrl(abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.CreateFileSystem, "PUT", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsRestOperation setFilesystemProperties(Hashtable<String, String> properties, TracingContext tracingContext) throws AzureBlobFileSystemException {
        String commaSeparatedProperties;
        try {
            commaSeparatedProperties = this.convertXmsPropertiesToCommaSeparatedString(properties);
        }
        catch (CharacterCodingException ex) {
            throw new InvalidAbfsRestOperationException(ex);
        }
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        requestHeaders.add(new AbfsHttpHeader("x-ms-properties", commaSeparatedProperties));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("resource", "filesystem");
        URL url = this.createRequestUrl(abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.SetFileSystemProperties, "PUT", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsRestOperation getFilesystemProperties(TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("resource", "filesystem");
        URL url = this.createRequestUrl(abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.GetFileSystemProperties, "HEAD", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsRestOperation deleteFilesystem(TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("resource", "filesystem");
        URL url = this.createRequestUrl(abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.DeleteFileSystem, "DELETE", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public ListResponseData listPath(String relativePath, boolean recursive, int listMaxResults, String continuation, TracingContext tracingContext, URI uri) throws IOException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("resource", "filesystem");
        abfsUriQueryBuilder.addQuery("directory", AbfsDfsClient.getDirectoryQueryParameter(relativePath));
        abfsUriQueryBuilder.addQuery("recursive", String.valueOf(recursive));
        abfsUriQueryBuilder.addQuery("continuation", continuation);
        abfsUriQueryBuilder.addQuery("maxResults", String.valueOf(listMaxResults));
        abfsUriQueryBuilder.addQuery("upn", String.valueOf(this.getAbfsConfiguration().isUpnUsed()));
        this.appendSASTokenToQuery(relativePath, "list", abfsUriQueryBuilder);
        URL url = this.createRequestUrl(abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.ListPaths, "GET", url, requestHeaders);
        op.execute(tracingContext);
        ListResponseData listResponseData = this.parseListPathResults(op.getResult(), uri);
        listResponseData.setOp(op);
        return listResponseData;
    }

    @Override
    public List<FileStatus> postListProcessing(String relativePath, List<FileStatus> fileStatuses, TracingContext tracingContext, URI uri) {
        return fileStatuses;
    }

    @Override
    public AbfsRestOperation createPath(String path, boolean isFile, boolean overwrite, AzureBlobFileSystemStore.Permissions permissions, boolean isAppendBlob, String eTag, ContextEncryptionAdapter contextEncryptionAdapter, TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        if (isFile) {
            this.addEncryptionKeyRequestHeaders(path, requestHeaders, true, contextEncryptionAdapter, tracingContext);
        }
        if (!overwrite) {
            requestHeaders.add(new AbfsHttpHeader("If-None-Match", "*"));
        }
        if (permissions.hasPermission().booleanValue()) {
            requestHeaders.add(new AbfsHttpHeader("x-ms-permissions", permissions.getPermission()));
        }
        if (permissions.hasUmask().booleanValue()) {
            requestHeaders.add(new AbfsHttpHeader("x-ms-umask", permissions.getUmask()));
        }
        if (eTag != null && !eTag.isEmpty()) {
            requestHeaders.add(new AbfsHttpHeader("If-Match", eTag));
        }
        String clientTransactionId = this.addClientTransactionIdToHeader(requestHeaders);
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("resource", isFile ? "file" : "directory");
        if (isAppendBlob) {
            abfsUriQueryBuilder.addQuery("blobtype", "appendblob");
        }
        String operation = isFile ? "create-file" : "create-directory";
        this.appendSASTokenToQuery(path, operation, abfsUriQueryBuilder);
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.CreatePath, "PUT", url, requestHeaders);
        try {
            op.execute(tracingContext);
        }
        catch (AzureBlobFileSystemException ex) {
            if (!op.hasResult()) {
                throw ex;
            }
            if (!isFile) {
                String existingResource;
                if (op.getResult().getStatusCode() == 409 && (existingResource = op.getResult().getResponseHeader("x-ms-existing-resource-type")) != null && existingResource.equals("directory")) {
                    return this.getSuccessOp(AbfsRestOperationType.CreatePath, "PUT", url, requestHeaders);
                }
            } else if (op.isARetriedRequest() && clientTransactionId != null && (op.getResult().getStatusCode() == 409 || op.getResult().getStatusCode() == 412)) {
                try {
                    AbfsHttpOperation getPathStatusOp = this.getPathStatus(path, false, tracingContext, null).getResult();
                    if (clientTransactionId.equals(getPathStatusOp.getResponseHeader("x-ms-client-transaction-id"))) {
                        return this.getSuccessOp(AbfsRestOperationType.CreatePath, "PUT", url, requestHeaders);
                    }
                }
                catch (AzureBlobFileSystemException exception) {
                    throw new AbfsDriverException("Error while recovering from create failure.", exception);
                }
            }
            throw ex;
        }
        return op;
    }

    @Override
    public void createNonRecursivePreCheck(Path parentPath, TracingContext tracingContext) throws IOException {
        try {
            this.getPathStatus(parentPath.toUri().getPath(), false, tracingContext, null);
        }
        catch (AbfsRestOperationException ex) {
            if (ex.getStatusCode() == 404) {
                throw new FileNotFoundException("Cannot create file " + parentPath.toUri().getPath() + " because parent folder does not exist.");
            }
            throw ex;
        }
        finally {
            this.getAbfsCounters().incrementCounter(AbfsStatistic.CALL_GET_FILE_STATUS, 1L);
        }
    }

    @Override
    public AbfsRestOperation conditionalCreateOverwriteFile(String relativePath, FileSystem.Statistics statistics, AzureBlobFileSystemStore.Permissions permissions, boolean isAppendBlob, ContextEncryptionAdapter contextEncryptionAdapter, TracingContext tracingContext) throws IOException {
        AbfsRestOperation op;
        try {
            op = this.createPath(relativePath, true, false, permissions, isAppendBlob, null, contextEncryptionAdapter, tracingContext);
        }
        catch (AbfsRestOperationException e) {
            if (e.getStatusCode() == 409) {
                try {
                    op = this.getPathStatus(relativePath, false, tracingContext, null);
                }
                catch (AbfsRestOperationException ex) {
                    if (ex.getStatusCode() == 404) {
                        throw new ConcurrentWriteOperationDetectedException();
                    }
                    throw ex;
                }
                String eTag = AzureBlobFileSystemStore.extractEtagHeader(op.getResult());
                try {
                    op = this.createPath(relativePath, true, true, permissions, isAppendBlob, eTag, contextEncryptionAdapter, tracingContext);
                }
                catch (AbfsRestOperationException ex) {
                    if (ex.getStatusCode() == 412) {
                        throw new ConcurrentWriteOperationDetectedException();
                    }
                    throw ex;
                }
            }
            throw e;
        }
        return op;
    }

    @Override
    public AbfsRestOperation acquireLease(String path, int duration, String eTag, TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("x-ms-lease-action", "acquire"));
        requestHeaders.add(new AbfsHttpHeader("x-ms-lease-duration", Integer.toString(duration)));
        requestHeaders.add(new AbfsHttpHeader("x-ms-proposed-lease-id", UUID.randomUUID().toString()));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.LeasePath, "POST", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsRestOperation renewLease(String path, String leaseId, TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("x-ms-lease-action", "renew"));
        requestHeaders.add(new AbfsHttpHeader("x-ms-lease-id", leaseId));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.LeasePath, "POST", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsRestOperation releaseLease(String path, String leaseId, TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("x-ms-lease-action", "release"));
        requestHeaders.add(new AbfsHttpHeader("x-ms-lease-id", leaseId));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.LeasePath, "POST", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsRestOperation breakLease(String path, TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("x-ms-lease-action", "break"));
        requestHeaders.add(new AbfsHttpHeader("x-ms-lease-break-period", "0"));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.LeasePath, "POST", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsClientRenameResult renamePath(String source, String destination, String continuation, TracingContext tracingContext, String sourceEtag, boolean isMetadataIncompleteState) throws IOException {
        if (this.getIsNamespaceEnabled() && this.getAbfsConfiguration().getIsClientTransactionIdEnabled()) {
            return this.renameWithCTIdRecovery(source, destination, continuation, tracingContext, sourceEtag, isMetadataIncompleteState);
        }
        return this.renameWithETagRecovery(source, destination, continuation, tracingContext, sourceEtag, isMetadataIncompleteState);
    }

    @Override
    public AbfsRestOperation append(String path, byte[] buffer, AppendRequestParameters reqParams, String cachedSasToken, ContextEncryptionAdapter contextEncryptionAdapter, TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        this.addEncryptionKeyRequestHeaders(path, requestHeaders, false, contextEncryptionAdapter, tracingContext);
        if (reqParams.isExpectHeaderEnabled()) {
            requestHeaders.add(new AbfsHttpHeader("Expect", "100-continue"));
        }
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        if (reqParams.getLeaseId() != null) {
            requestHeaders.add(new AbfsHttpHeader("x-ms-lease-id", reqParams.getLeaseId()));
        }
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "append");
        abfsUriQueryBuilder.addQuery("position", Long.toString(reqParams.getPosition()));
        if (reqParams.getMode() == AppendRequestParameters.Mode.FLUSH_MODE || reqParams.getMode() == AppendRequestParameters.Mode.FLUSH_CLOSE_MODE) {
            abfsUriQueryBuilder.addQuery("flush", "true");
            if (reqParams.getMode() == AppendRequestParameters.Mode.FLUSH_CLOSE_MODE) {
                abfsUriQueryBuilder.addQuery("close", "true");
            }
        }
        if (reqParams.isRetryDueToExpect()) {
            String userAgentRetry = this.getUserAgent();
            userAgentRetry = userAgentRetry.replace(" 100-continue;", "");
            requestHeaders.removeIf(header -> header.getName().equalsIgnoreCase("User-Agent"));
            requestHeaders.add(new AbfsHttpHeader("User-Agent", userAgentRetry));
        }
        if (this.isChecksumValidationEnabled()) {
            this.addCheckSumHeaderForWrite(requestHeaders, reqParams);
        }
        String sasTokenForReuse = this.appendSASTokenToQuery(path, "write", abfsUriQueryBuilder, cachedSasToken);
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.Append, "PUT", url, requestHeaders, buffer, reqParams.getoffset(), reqParams.getLength(), sasTokenForReuse);
        try {
            op.execute(tracingContext);
        }
        catch (AbfsRestOperationException e) {
            int responseStatusCode = e.getStatusCode();
            if (this.checkUserError(responseStatusCode) && reqParams.isExpectHeaderEnabled()) {
                LOG.debug("User error, retrying without 100 continue enabled for the given path {}", (Object)path);
                reqParams.setExpectHeaderEnabled(false);
                reqParams.setRetryDueToExpect(true);
                return this.append(path, buffer, reqParams, cachedSasToken, contextEncryptionAdapter, tracingContext);
            }
            if (!op.hasResult()) {
                throw e;
            }
            if (this.isMd5ChecksumError(e)) {
                throw new AbfsInvalidChecksumException(e);
            }
            if (reqParams.isAppendBlob() && this.appendSuccessCheckOp(op, path, reqParams.getPosition() + (long)reqParams.getLength(), tracingContext)) {
                AbfsRestOperation successOp = this.getAbfsRestOperation(AbfsRestOperationType.Append, "PUT", url, requestHeaders, buffer, reqParams.getoffset(), reqParams.getLength(), sasTokenForReuse);
                successOp.hardSetResult(200);
                return successOp;
            }
            throw e;
        }
        catch (AzureBlobFileSystemException e) {
            LOG.debug("Append request failed with non server issues for path: {}, offset: {}, position: {}", new Object[]{path, reqParams.getoffset(), reqParams.getPosition()});
            throw e;
        }
        return op;
    }

    @Override
    public AbfsRestOperation flush(String path, long position, boolean retainUncommittedData, boolean isClose, String cachedSasToken, String leaseId, ContextEncryptionAdapter contextEncryptionAdapter, TracingContext tracingContext, String blobMd5) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        this.addEncryptionKeyRequestHeaders(path, requestHeaders, false, contextEncryptionAdapter, tracingContext);
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        if (leaseId != null) {
            requestHeaders.add(new AbfsHttpHeader("x-ms-lease-id", leaseId));
        }
        if (this.isFullBlobChecksumValidationEnabled() && blobMd5 != null) {
            requestHeaders.add(new AbfsHttpHeader("x-ms-blob-content-md5", blobMd5));
        }
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "flush");
        abfsUriQueryBuilder.addQuery("position", Long.toString(position));
        abfsUriQueryBuilder.addQuery("retainUncommittedData", String.valueOf(retainUncommittedData));
        abfsUriQueryBuilder.addQuery("close", String.valueOf(isClose));
        String sasTokenForReuse = this.appendSASTokenToQuery(path, "write", abfsUriQueryBuilder, cachedSasToken);
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.Flush, "PUT", url, requestHeaders, sasTokenForReuse);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsRestOperation flush(byte[] buffer, String path, boolean isClose, String cachedSasToken, String leaseId, String eTag, ContextEncryptionAdapter contextEncryptionAdapter, TracingContext tracingContext, String blobMd5) throws AzureBlobFileSystemException {
        throw new UnsupportedOperationException("Flush with blockIds not supported on DFS Endpoint");
    }

    @Override
    public AbfsRestOperation setPathProperties(String path, Hashtable<String, String> properties, TracingContext tracingContext, ContextEncryptionAdapter contextEncryptionAdapter) throws AzureBlobFileSystemException {
        String commaSeparatedProperties;
        try {
            commaSeparatedProperties = this.convertXmsPropertiesToCommaSeparatedString(properties);
        }
        catch (CharacterCodingException ex) {
            throw new InvalidAbfsRestOperationException(ex);
        }
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        this.addEncryptionKeyRequestHeaders(path, requestHeaders, false, contextEncryptionAdapter, tracingContext);
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        requestHeaders.add(new AbfsHttpHeader("x-ms-properties", commaSeparatedProperties));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "setProperties");
        this.appendSASTokenToQuery(path, "set-properties", abfsUriQueryBuilder);
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.SetPathProperties, "PUT", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsRestOperation getPathStatus(String path, boolean includeProperties, TracingContext tracingContext, ContextEncryptionAdapter contextEncryptionAdapter) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        String operation = "get-properties";
        if (!includeProperties) {
            abfsUriQueryBuilder.addQuery("action", "getStatus");
            operation = "get-status";
        } else {
            this.addEncryptionKeyRequestHeaders(path, requestHeaders, false, contextEncryptionAdapter, tracingContext);
        }
        abfsUriQueryBuilder.addQuery("upn", String.valueOf(this.getAbfsConfiguration().isUpnUsed()));
        this.appendSASTokenToQuery(path, operation, abfsUriQueryBuilder);
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.GetPathStatus, "HEAD", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsRestOperation read(String path, long position, byte[] buffer, int bufferOffset, int bufferLength, String eTag, String cachedSasToken, ContextEncryptionAdapter contextEncryptionAdapter, TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        this.addEncryptionKeyRequestHeaders(path, requestHeaders, false, contextEncryptionAdapter, tracingContext);
        AbfsHttpHeader rangeHeader = new AbfsHttpHeader("Range", String.format("bytes=%d-%d", position, position + (long)bufferLength - 1L));
        requestHeaders.add(rangeHeader);
        requestHeaders.add(new AbfsHttpHeader("If-Match", eTag));
        if (this.isChecksumValidationEnabled(requestHeaders, rangeHeader, bufferLength)) {
            requestHeaders.add(new AbfsHttpHeader("x-ms-range-get-content-md5", "true"));
        }
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        String sasTokenForReuse = this.appendSASTokenToQuery(path, "read", abfsUriQueryBuilder, cachedSasToken);
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.ReadFile, "GET", url, requestHeaders, buffer, bufferOffset, bufferLength, sasTokenForReuse);
        op.execute(tracingContext);
        if (this.isChecksumValidationEnabled(requestHeaders, rangeHeader, bufferLength)) {
            this.verifyCheckSumForRead(buffer, op.getResult(), bufferOffset);
        }
        return op;
    }

    @Override
    public AbfsRestOperation deletePath(String path, boolean recursive, String continuation, TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.isPaginatedDelete(recursive, this.getIsNamespaceEnabled()) != false && this.getxMsVersion().compareTo(AbfsHttpConstants.ApiVersion.AUG_03_2023) < 0 ? this.createDefaultHeaders(AbfsHttpConstants.ApiVersion.AUG_03_2023) : this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        if (this.isPaginatedDelete(recursive, this.getIsNamespaceEnabled()).booleanValue()) {
            abfsUriQueryBuilder.addQuery("paginated", "true");
        }
        abfsUriQueryBuilder.addQuery("recursive", String.valueOf(recursive));
        abfsUriQueryBuilder.addQuery("continuation", continuation);
        String operation = recursive ? "delete-recursive" : "delete";
        this.appendSASTokenToQuery(path, operation, abfsUriQueryBuilder);
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.DeletePath, this, "DELETE", url, requestHeaders, this.getAbfsConfiguration());
        try {
            op.execute(tracingContext);
        }
        catch (AzureBlobFileSystemException e) {
            if (!op.hasResult()) {
                throw e;
            }
            AbfsRestOperation idempotencyOp = this.deleteIdempotencyCheckOp(op);
            if (idempotencyOp.getResult().getStatusCode() == op.getResult().getStatusCode()) {
                throw e;
            }
            return idempotencyOp;
        }
        return op;
    }

    @Override
    public AbfsRestOperation setOwner(String path, String owner, String group, TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        if (owner != null && !owner.isEmpty()) {
            requestHeaders.add(new AbfsHttpHeader("x-ms-owner", owner));
        }
        if (group != null && !group.isEmpty()) {
            requestHeaders.add(new AbfsHttpHeader("x-ms-group", group));
        }
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "setAccessControl");
        this.appendSASTokenToQuery(path, "set-owner", abfsUriQueryBuilder);
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.SetOwner, "PUT", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsRestOperation setPermission(String path, String permission, TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        requestHeaders.add(new AbfsHttpHeader("x-ms-permissions", permission));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "setAccessControl");
        this.appendSASTokenToQuery(path, "set-permission", abfsUriQueryBuilder);
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.SetPermissions, "PUT", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsRestOperation setAcl(String path, String aclSpecString, String eTag, TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        requestHeaders.add(new AbfsHttpHeader("x-ms-acl", aclSpecString));
        if (eTag != null && !eTag.isEmpty()) {
            requestHeaders.add(new AbfsHttpHeader("If-Match", eTag));
        }
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "setAccessControl");
        this.appendSASTokenToQuery(path, "set-acl", abfsUriQueryBuilder);
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.SetAcl, "PUT", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsRestOperation getAclStatus(String path, boolean useUPN, TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "getAccessControl");
        abfsUriQueryBuilder.addQuery("upn", String.valueOf(useUPN));
        this.appendSASTokenToQuery(path, "get-acl", abfsUriQueryBuilder);
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.GetAcl, "HEAD", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public AbfsRestOperation checkAccess(String path, String rwx, TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "checkAccess");
        abfsUriQueryBuilder.addQuery("fsAction", rwx);
        this.appendSASTokenToQuery(path, "check-access", abfsUriQueryBuilder);
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.CheckAccess, "HEAD", url, requestHeaders);
        op.execute(tracingContext);
        return op;
    }

    @Override
    public boolean checkIsDir(AbfsHttpOperation result) {
        String resourceType = result.getResponseHeader("x-ms-resource-type");
        return StringUtils.equalsIgnoreCase((String)resourceType, (String)"directory");
    }

    @Override
    public boolean checkUserError(int responseStatusCode) {
        return responseStatusCode >= 400 && responseStatusCode < 500 && responseStatusCode != 409;
    }

    private String getContinuationFromResponse(AbfsHttpOperation result) {
        return result.getResponseHeader("x-ms-continuation");
    }

    @Override
    public Hashtable<String, String> getXMSProperties(AbfsHttpOperation result) throws InvalidFileSystemPropertyException, InvalidAbfsRestOperationException {
        return this.parseCommaSeparatedXmsProperties(result.getResponseHeader("x-ms-properties"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ListResponseData parseListPathResults(AbfsHttpOperation result, URI uri) throws AzureBlobFileSystemException {
        try {
            Throwable throwable = null;
            try (InputStream stream = result.getListResultStream();){
                ObjectMapper objectMapper = new ObjectMapper();
                DfsListResultSchema listResultSchema = (DfsListResultSchema)objectMapper.readValue(stream, DfsListResultSchema.class);
                result.setListResultSchema(listResultSchema);
                LOG.debug("ListPath listed {} paths with {} as continuation token", (Object)listResultSchema.paths().size(), (Object)this.getContinuationFromResponse(result));
                ArrayList<VersionedFileStatus> fileStatuses = new ArrayList<VersionedFileStatus>();
                for (DfsListResultEntrySchema entry : listResultSchema.paths()) {
                    fileStatuses.add(this.getVersionedFileStatusFromEntry(entry, uri));
                }
                ListResponseData listResponseData = new ListResponseData();
                listResponseData.setFileStatusList(fileStatuses);
                listResponseData.setRenamePendingJsonPaths(null);
                listResponseData.setContinuationToken(this.getContinuationFromResponse(result));
                ListResponseData listResponseData2 = listResponseData;
                return listResponseData2;
            }
            catch (JsonParseException | JsonMappingException ex) {
                try {
                    throw new AbfsDriverException("Parsing of Json List Response Failed in DfsClient.", (Exception)ex);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (AbfsDriverException ex) {
            LOG.error("Unable to deserialize list results for Uri {}", (Object)(uri != null ? uri.toString() : "NULL"), (Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.error("Unable to deserialize list results for Uri {}", (Object)(uri != null ? uri.toString() : "NULL"), (Object)ex);
            throw new AbfsDriverException("Parsing of Json List Response Failed in DfsClient.", ex);
        }
    }

    @Override
    public List<String> parseBlockListResponse(InputStream stream) throws IOException {
        return null;
    }

    @Override
    public StorageErrorResponseSchema processStorageErrorResponse(InputStream stream) throws IOException {
        String storageErrorCode = "";
        String storageErrorMessage = "";
        String expectedAppendPos = "";
        JsonFactory jf = new JsonFactory();
        try (JsonParser jp = jf.createParser(stream);){
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
            while (jp.hasCurrentToken()) {
                if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = jp.getCurrentName();
                    jp.nextToken();
                    String fieldValue = jp.getText();
                    switch (fieldName) {
                        case "code": {
                            storageErrorCode = fieldValue;
                            break;
                        }
                        case "message": {
                            storageErrorMessage = fieldValue;
                            break;
                        }
                        case "ExpectedAppendPos": {
                            expectedAppendPos = fieldValue;
                            break;
                        }
                    }
                }
                jp.nextToken();
            }
        }
        return new StorageErrorResponseSchema(storageErrorCode, storageErrorMessage, expectedAppendPos);
    }

    @Override
    public byte[] encodeAttribute(String value) throws UnsupportedEncodingException {
        return value.getBytes("ISO-8859-1");
    }

    @Override
    public String decodeAttribute(byte[] value) throws UnsupportedEncodingException {
        return new String(value, "ISO-8859-1");
    }

    private String convertXmsPropertiesToCommaSeparatedString(Map<String, String> properties) throws CharacterCodingException {
        StringBuilder commaSeparatedProperties = new StringBuilder();
        CharsetEncoder encoder = Charset.forName("ISO-8859-1").newEncoder();
        for (Map.Entry<String, String> propertyEntry : properties.entrySet()) {
            String key = propertyEntry.getKey();
            String value = propertyEntry.getValue();
            Boolean canEncodeValue = encoder.canEncode(value);
            if (!canEncodeValue.booleanValue()) {
                LOG.error("Property value {} cannot be encoded using ASCII encoding", (Object)value);
                throw new CharacterCodingException();
            }
            String encodedPropertyValue = Base64.encode(encoder.encode(CharBuffer.wrap(value)).array());
            commaSeparatedProperties.append(key).append("=").append(encodedPropertyValue);
            commaSeparatedProperties.append(",");
        }
        if (commaSeparatedProperties.length() != 0) {
            commaSeparatedProperties.deleteCharAt(commaSeparatedProperties.length() - 1);
        }
        return commaSeparatedProperties.toString();
    }

    private Hashtable<String, String> parseCommaSeparatedXmsProperties(String xMsProperties) throws InvalidFileSystemPropertyException, InvalidAbfsRestOperationException {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        CharsetDecoder decoder = Charset.forName("ISO-8859-1").newDecoder();
        if (xMsProperties != null && !xMsProperties.isEmpty()) {
            String[] userProperties = xMsProperties.split(",");
            if (userProperties.length == 0) {
                return properties;
            }
            for (String property : userProperties) {
                String value;
                if (property.isEmpty()) {
                    throw new InvalidFileSystemPropertyException(xMsProperties);
                }
                String[] nameValue = property.split("=", 2);
                if (nameValue.length != 2) {
                    throw new InvalidFileSystemPropertyException(xMsProperties);
                }
                byte[] decodedValue = Base64.decode(nameValue[1]);
                try {
                    value = decoder.decode(ByteBuffer.wrap(decodedValue)).toString();
                }
                catch (CharacterCodingException ex) {
                    throw new InvalidAbfsRestOperationException(ex);
                }
                properties.put(nameValue[0], value);
            }
        }
        return properties;
    }

    @VisibleForTesting
    public String addClientTransactionIdToHeader(List<AbfsHttpHeader> requestHeaders) throws AzureBlobFileSystemException {
        String clientTransactionId = null;
        if (this.getIsNamespaceEnabled() && this.getAbfsConfiguration().getIsClientTransactionIdEnabled()) {
            clientTransactionId = UUID.randomUUID().toString();
            requestHeaders.add(new AbfsHttpHeader("x-ms-client-transaction-id", clientTransactionId));
        }
        return clientTransactionId;
    }

    private AbfsClientRenameResult renameWithCTIdRecovery(String source, String destination, String continuation, TracingContext tracingContext, String sourceEtag, boolean isMetadataIncompleteState) throws IOException {
        List<AbfsHttpHeader> requestHeaders = this.getHeadersForRename(source);
        String clientTransactionId = this.addClientTransactionIdToHeader(requestHeaders);
        URL url = this.createRequestUrl(destination, this.getRenameQueryBuilder(destination, continuation).toString());
        AbfsRestOperation op = this.createRenameRestOperation(url, requestHeaders);
        try {
            this.incrementAbfsRenamePath();
            op.execute(tracingContext);
            return new AbfsClientRenameResult(op, isMetadataIncompleteState, isMetadataIncompleteState);
        }
        catch (AzureBlobFileSystemException e) {
            this.handleRenameException(source, destination, continuation, tracingContext, sourceEtag, op, isMetadataIncompleteState, e);
            if (op.isARetriedRequest() && AzureServiceErrorCode.SOURCE_PATH_NOT_FOUND.getErrorCode().equalsIgnoreCase(op.getResult().getStorageErrorCode()) && this.recoveryUsingCTId(destination, tracingContext, clientTransactionId)) {
                return new AbfsClientRenameResult(this.getSuccessOp(AbfsRestOperationType.RenamePath, "PUT", url, requestHeaders), true, isMetadataIncompleteState);
            }
            if (this.recoveryUsingEtag(source, destination, sourceEtag, op, tracingContext, true)) {
                return new AbfsClientRenameResult(this.getSuccessOp(AbfsRestOperationType.RenamePath, "PUT", url, requestHeaders), true, isMetadataIncompleteState);
            }
            throw e;
        }
    }

    private AbfsClientRenameResult renameWithETagRecovery(String source, String destination, String continuation, TracingContext tracingContext, String sourceEtag, boolean isMetadataIncompleteState) throws IOException {
        boolean shouldAttemptRecovery;
        boolean hasEtag = !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sourceEtag);
        boolean bl = shouldAttemptRecovery = this.isRenameResilience() && this.getIsNamespaceEnabled();
        if (!hasEtag && shouldAttemptRecovery) {
            try {
                AbfsRestOperation srcStatusOp = this.getPathStatus(source, false, tracingContext, null);
                if (srcStatusOp.hasResult()) {
                    AbfsHttpOperation result = srcStatusOp.getResult();
                    sourceEtag = AzureBlobFileSystemStore.extractEtagHeader(result);
                    boolean isDir = this.checkIsDir(result);
                    shouldAttemptRecovery = !isDir;
                    LOG.debug("Retrieved etag of source for rename recovery: {}; isDir={}", (Object)sourceEtag, (Object)isDir);
                }
            }
            catch (AbfsRestOperationException e) {
                throw new AbfsRestOperationException(e.getStatusCode(), AzureServiceErrorCode.SOURCE_PATH_NOT_FOUND.getErrorCode(), e.getMessage(), e);
            }
        }
        List<AbfsHttpHeader> requestHeaders = this.getHeadersForRename(source);
        URL url = this.createRequestUrl(destination, this.getRenameQueryBuilder(destination, continuation).toString());
        AbfsRestOperation op = this.createRenameRestOperation(url, requestHeaders);
        try {
            this.incrementAbfsRenamePath();
            op.execute(tracingContext);
            return new AbfsClientRenameResult(op, isMetadataIncompleteState, isMetadataIncompleteState);
        }
        catch (AzureBlobFileSystemException e) {
            this.handleRenameException(source, destination, continuation, tracingContext, sourceEtag, op, isMetadataIncompleteState, e);
            if (this.recoveryUsingEtag(source, destination, sourceEtag, op, tracingContext, shouldAttemptRecovery)) {
                return new AbfsClientRenameResult(this.getSuccessOp(AbfsRestOperationType.RenamePath, "PUT", url, requestHeaders), true, isMetadataIncompleteState);
            }
            throw e;
        }
    }

    private List<AbfsHttpHeader> getHeadersForRename(String source) throws IOException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        String encodedRenameSource = AbfsDfsClient.urlEncode("/" + this.getFileSystem() + source);
        if (this.getAuthType() == AuthType.SAS) {
            AbfsUriQueryBuilder srcQueryBuilder = new AbfsUriQueryBuilder();
            this.appendSASTokenToQuery(source, "rename-source", srcQueryBuilder);
            encodedRenameSource = encodedRenameSource + srcQueryBuilder.toString();
        }
        LOG.trace("Rename source queryparam added {}", (Object)encodedRenameSource);
        requestHeaders.add(new AbfsHttpHeader("x-ms-rename-source", encodedRenameSource));
        requestHeaders.add(new AbfsHttpHeader("If-None-Match", "*"));
        return requestHeaders;
    }

    private AbfsUriQueryBuilder getRenameQueryBuilder(String destination, String continuation) throws AzureBlobFileSystemException {
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("continuation", continuation);
        this.appendSASTokenToQuery(destination, "rename-destination", abfsUriQueryBuilder);
        return abfsUriQueryBuilder;
    }

    private boolean recoveryUsingCTId(String destination, TracingContext tracingContext, String clientTransactionId) throws AzureBlobFileSystemException {
        try {
            AbfsHttpOperation abfsHttpOperation = this.getPathStatus(destination, false, tracingContext, null).getResult();
            return clientTransactionId.equals(abfsHttpOperation.getResponseHeader("x-ms-client-transaction-id"));
        }
        catch (AzureBlobFileSystemException exception) {
            throw new AbfsDriverException("Error while recovering from rename failure for path: " + destination, exception);
        }
    }

    private boolean recoveryUsingEtag(String source, String destination, String sourceEtag, AbfsRestOperation op, TracingContext tracingContext, boolean shouldAttemptRecovery) {
        if (shouldAttemptRecovery && this.isRenameResilience()) {
            return this.renameIdempotencyCheckOp(source, sourceEtag, op, destination, tracingContext);
        }
        return false;
    }

    private void handleRenameException(String source, String destination, String continuation, TracingContext tracingContext, String sourceEtag, AbfsRestOperation op, boolean isMetadataIncompleteState, AzureBlobFileSystemException e) throws IOException {
        if (!op.hasResult()) {
            throw e;
        }
        if (AzureServiceErrorCode.UNAUTHORIZED_BLOB_OVERWRITE.getErrorCode().equals(op.getResult().getStorageErrorCode())) {
            throw new FileAlreadyExistsException("File already exists.");
        }
        if (AzureServiceErrorCode.RENAME_DESTINATION_PARENT_PATH_NOT_FOUND.getErrorCode().equals(op.getResult().getStorageErrorCode()) && !isMetadataIncompleteState) {
            ABFS_METADATA_INCOMPLETE_RENAME_FAILURE.info("Rename Failure attempting to resolve tracking metadata state and retrying.", new Object[0]);
            isMetadataIncompleteState = true;
            String sourceEtagAfterFailure = sourceEtag;
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sourceEtagAfterFailure)) {
                AbfsRestOperation sourceStatusOp = this.getPathStatus(source, false, tracingContext, null);
                AbfsHttpOperation sourceStatusResult = sourceStatusOp.getResult();
                sourceEtagAfterFailure = AzureBlobFileSystemStore.extractEtagHeader(sourceStatusResult);
            }
            this.renamePath(source, destination, continuation, tracingContext, sourceEtagAfterFailure, isMetadataIncompleteState);
        }
    }
}

