/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRenameWithOrderedSnapshotDeletion {
    private final Path snapshottableDir = new Path("/" + this.getClass().getSimpleName());
    private DistributedFileSystem hdfs;
    private MiniDFSCluster cluster;

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.snapshot.deletion.ordered", true);
        conf.setBoolean("dfs.namenode.snapshot.trashroot.enabled", true);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        this.cluster.waitActive();
        this.hdfs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test(timeout=60000L)
    public void testRename() throws Exception {
        Path dir1 = new Path("/dir1");
        Path dir2 = new Path("/dir2");
        Path sub0 = new Path(this.snapshottableDir, "sub0");
        Path sub1 = new Path(this.snapshottableDir, "sub1");
        this.hdfs.mkdirs(sub0);
        this.hdfs.mkdirs(dir2);
        Path file1 = new Path(dir1, "file1");
        Path file2 = new Path(sub0, "file2");
        this.hdfs.mkdirs(this.snapshottableDir);
        this.hdfs.mkdirs(dir1);
        this.hdfs.mkdirs(dir2);
        this.hdfs.mkdirs(sub0);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file1, 0L, (short)1, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file2, 0L, (short)1, 0L);
        this.hdfs.allowSnapshot(this.snapshottableDir);
        this.validateRename(file1, sub0);
        this.hdfs.createSnapshot(this.snapshottableDir, "s0");
        this.validateRename(file1, sub0);
        this.hdfs.rename(file1, dir2);
        this.validateRename(file2, dir1);
        this.hdfs.rename(file2, this.snapshottableDir);
        this.hdfs.rename(dir2, dir1);
        this.validateRename(dir1, this.snapshottableDir);
        this.validateRename(sub0, dir2);
        this.hdfs.rename(sub0, sub1);
    }

    private void validateRename(Path src, Path dest) {
        try {
            this.hdfs.rename(src, dest);
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getMessage().contains("are not under the same snapshot root."));
        }
    }
}

