/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.common.config;

import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.resourceestimator.common.exception.ResourceEstimatorException;

public final class ResourceEstimatorUtil {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];

    private ResourceEstimatorUtil() {
    }

    public static <T> T createProviderInstance(Configuration conf, String configuredClassName, String defaultValue, Class<T> type) throws ResourceEstimatorException {
        String className = conf.get(configuredClassName);
        if (className == null) {
            className = defaultValue;
        }
        try {
            Class<?> concreteClass = Class.forName(className);
            if (type.isAssignableFrom(concreteClass)) {
                Constructor<?> meth = concreteClass.getDeclaredConstructor(EMPTY_ARRAY);
                meth.setAccessible(true);
                return (T)meth.newInstance(new Object[0]);
            }
            StringBuilder errMsg = new StringBuilder();
            errMsg.append("Class: ").append(className).append(" not instance of ").append(type.getCanonicalName());
            throw new ResourceEstimatorException(errMsg.toString());
        }
        catch (ClassNotFoundException e) {
            StringBuilder errMsg = new StringBuilder();
            errMsg.append("Could not instantiate : ").append(className).append(" due to exception: ").append(e.getCause());
            throw new ResourceEstimatorException(errMsg.toString());
        }
        catch (ReflectiveOperationException e) {
            StringBuilder errMsg = new StringBuilder();
            errMsg.append("Could not instantiate : ").append(className).append(" due to exception: ").append(e.getCause());
            throw new ResourceEstimatorException(errMsg.toString());
        }
    }
}

