/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver.order;

import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.HashResolver;

public class HashFirstResolver
extends HashResolver {
    @Override
    public String getFirstNamespace(String path, PathLocation loc) {
        String srcPath = loc.getSourcePath();
        String trimmedPath = HashFirstResolver.trimPathToChild(path, srcPath);
        LOG.debug("Only using the first part of the path: {} -> {}", (Object)path, (Object)trimmedPath);
        return super.getFirstNamespace(trimmedPath, loc);
    }

    private static String trimPathToChild(String path, String parent) {
        if (path.length() <= parent.length()) {
            return parent;
        }
        String remainder = path.substring(parent.length());
        String[] components = remainder.replaceFirst("^/", "").split("/");
        if (components.length > 0 && components[0].length() > 0) {
            if (parent.endsWith("/")) {
                return parent + components[0];
            }
            return parent + "/" + components[0];
        }
        return parent;
    }
}

