/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.cosn.ByteBufferWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferPool {
    private static final Logger LOG = LoggerFactory.getLogger(BufferPool.class);
    private static BufferPool ourInstance = new BufferPool();
    private BlockingQueue<ByteBuffer> bufferPool = null;
    private long singleBufferSize = 0L;
    private File diskBufferDir = null;
    private AtomicBoolean isInitialize = new AtomicBoolean(false);

    public static BufferPool getInstance() {
        return ourInstance;
    }

    private BufferPool() {
    }

    private File createDir(String dirPath) throws IOException {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            LOG.debug("Buffer dir: [{}] does not exists. create it first.", (Object)dirPath);
            if (dir.mkdirs()) {
                if (!(dir.setWritable(true) && dir.setReadable(true) && dir.setExecutable(true))) {
                    LOG.warn("Set the buffer dir: [{}]'s permission [writable,readable, executable] failed.", (Object)dir.getAbsolutePath());
                }
                LOG.debug("Buffer dir: [{}] is created successfully.", (Object)dir.getAbsolutePath());
            } else if (!dir.exists()) {
                throw new IOException("buffer dir:" + dir.getAbsolutePath() + " is created unsuccessfully");
            }
        } else {
            LOG.debug("buffer dir: {} already exists.", (Object)dirPath);
        }
        return dir;
    }

    public synchronized void initialize(Configuration conf) throws IOException {
        if (this.isInitialize.get()) {
            return;
        }
        this.singleBufferSize = conf.getLong("fs.cosn.block.size", 0x800000L);
        if (this.singleBufferSize < 0x100000L || this.singleBufferSize > 0x80000000L) {
            String exceptionMsg = String.format("The block size of CosN is limited to %d to %d", 0x100000L, 0x80000000L);
            throw new IOException(exceptionMsg);
        }
        long memoryBufferLimit = conf.getLong("fs.cosn.buffer.size", 0x2000000L);
        this.diskBufferDir = this.createDir(conf.get("fs.cosn.tmp.dir", "/tmp/hadoop_cos"));
        int bufferPoolSize = (int)(memoryBufferLimit / this.singleBufferSize);
        if (0 == bufferPoolSize) {
            throw new IOException(String.format("The total size of the buffer [%d] is smaller than a single block [%d].please consider increase the buffer size or decrease the block size", memoryBufferLimit, this.singleBufferSize));
        }
        this.bufferPool = new LinkedBlockingQueue<ByteBuffer>(bufferPoolSize);
        for (int i = 0; i < bufferPoolSize; ++i) {
            this.bufferPool.add(ByteBuffer.allocateDirect((int)this.singleBufferSize));
        }
        this.isInitialize.set(true);
    }

    private void checkInitialize() throws IOException {
        if (!this.isInitialize.get()) {
            throw new IOException("The buffer pool has not been initialized yet");
        }
    }

    public ByteBufferWrapper getBuffer(int bufferSize) throws IOException {
        this.checkInitialize();
        if (bufferSize > 0 && (long)bufferSize <= this.singleBufferSize) {
            ByteBufferWrapper byteBufferWrapper = this.getByteBuffer();
            if (null == byteBufferWrapper) {
                byteBufferWrapper = this.getMappedBuffer();
            }
            return byteBufferWrapper;
        }
        String exceptionMsg = String.format("Parameter buffer size out of range: 1048576 to %d", this.singleBufferSize);
        throw new IOException(exceptionMsg);
    }

    private ByteBufferWrapper getByteBuffer() throws IOException {
        this.checkInitialize();
        ByteBuffer buffer = (ByteBuffer)this.bufferPool.poll();
        return buffer == null ? null : new ByteBufferWrapper(buffer);
    }

    private ByteBufferWrapper getMappedBuffer() throws IOException {
        this.checkInitialize();
        File tmpFile = File.createTempFile("cos_", "_local_block", this.diskBufferDir);
        tmpFile.deleteOnExit();
        RandomAccessFile raf = new RandomAccessFile(tmpFile, "rw");
        raf.setLength(this.singleBufferSize);
        MappedByteBuffer buf = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.singleBufferSize);
        return new ByteBufferWrapper(buf, raf, tmpFile);
    }

    public void returnBuffer(ByteBufferWrapper byteBufferWrapper) throws InterruptedException, IOException {
        if (null == this.bufferPool || null == byteBufferWrapper) {
            return;
        }
        if (byteBufferWrapper.isDiskBuffer()) {
            byteBufferWrapper.close();
        } else {
            ByteBuffer byteBuffer = byteBufferWrapper.getByteBuffer();
            if (null != byteBuffer) {
                byteBuffer.clear();
                LOG.debug("Return the buffer to the buffer pool.");
                if (!this.bufferPool.offer(byteBuffer)) {
                    LOG.error("Return the buffer to buffer pool failed.");
                }
            }
        }
    }
}

