/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.util;

import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.s3.analyticsaccelerator.exceptions.ExceptionHandler;
import software.amazon.s3.analyticsaccelerator.request.Constants;
import software.amazon.s3.analyticsaccelerator.request.StreamAuditContext;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

public class ObjectClientUtil {
    public static Throwable handleException(S3URI s3Uri, Throwable throwable) {
        Throwable cause = Optional.ofNullable(throwable.getCause()).filter(t -> throwable instanceof CompletionException || throwable instanceof ExecutionException).orElse(throwable);
        return ExceptionHandler.toIOException(cause, s3Uri);
    }

    public static void attachStreamContextToExecutionAttributes(AwsRequestOverrideConfiguration.Builder requestOverrideConfigurationBuilder, StreamAuditContext streamAuditContext) {
        ((AwsRequestOverrideConfiguration.Builder)requestOverrideConfigurationBuilder.putExecutionAttribute(Constants.SPAN_ID, (Object)streamAuditContext.getSpanId())).putExecutionAttribute(Constants.OPERATION_NAME, (Object)streamAuditContext.getOperationName());
    }
}

