/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred.lib;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.tools.mapred.lib.DynamicInputChunk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicInputChunkContext<K, V> {
    private static Logger LOG = LoggerFactory.getLogger(DynamicInputChunkContext.class);
    private Configuration configuration;
    private Path chunkRootPath = null;
    private String chunkFilePrefix;
    private FileSystem fs;
    private int numChunksLeft = -1;

    public DynamicInputChunkContext(Configuration config) throws IOException {
        this.configuration = config;
        Path listingFilePath = new Path(DynamicInputChunkContext.getListingFilePath(this.configuration));
        this.chunkRootPath = new Path(listingFilePath.getParent(), "chunkDir");
        this.fs = this.chunkRootPath.getFileSystem(this.configuration);
        this.chunkFilePrefix = listingFilePath.getName() + ".chunk.";
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Path getChunkRootPath() {
        return this.chunkRootPath;
    }

    public String getChunkFilePrefix() {
        return this.chunkFilePrefix;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    private static String getListingFilePath(Configuration configuration) {
        String listingFileString = configuration.get("distcp.listing.file.path", "");
        assert (!listingFileString.equals("")) : "Listing file not found.";
        return listingFileString;
    }

    public int getNumChunksLeft() {
        return this.numChunksLeft;
    }

    public DynamicInputChunk acquire(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        String taskId = taskAttemptContext.getTaskAttemptID().getTaskID().toString();
        Path acquiredFilePath = new Path(this.getChunkRootPath(), taskId);
        if (this.fs.exists(acquiredFilePath)) {
            LOG.info("Acquiring pre-assigned chunk: " + acquiredFilePath);
            return new DynamicInputChunk(acquiredFilePath, taskAttemptContext, this);
        }
        for (FileStatus chunkFile : this.getListOfChunkFiles()) {
            if (!this.fs.rename(chunkFile.getPath(), acquiredFilePath)) continue;
            LOG.info(taskId + " acquired " + chunkFile.getPath());
            return new DynamicInputChunk(acquiredFilePath, taskAttemptContext, this);
        }
        return null;
    }

    public DynamicInputChunk createChunkForWrite(String chunkId) throws IOException {
        return new DynamicInputChunk(chunkId, this);
    }

    public FileStatus[] getListOfChunkFiles() throws IOException {
        Path chunkFilePattern = new Path(this.chunkRootPath, this.chunkFilePrefix + "*");
        FileStatus[] chunkFiles = this.fs.globStatus(chunkFilePattern);
        this.numChunksLeft = chunkFiles.length;
        return chunkFiles;
    }
}

