/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.loadGenerator;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.loadGenerator.DataGenerator;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadGenerator
extends Configured
implements Tool {
    public static final Logger LOG = LoggerFactory.getLogger(LoadGenerator.class);
    private static volatile boolean shouldRun = true;
    protected static Path root = DataGenerator.DEFAULT_ROOT;
    private static FileContext fc;
    protected static int maxDelayBetweenOps;
    protected static int numOfThreads;
    protected static long[] durations;
    protected static double[] readProbs;
    protected static double[] writeProbs;
    private static volatile int currentIndex;
    protected static long totalTime;
    protected static long startTime;
    private static final int BLOCK_SIZE = 10;
    private static ArrayList<String> files;
    private static ArrayList<String> dirs;
    protected static Random r;
    protected static long seed;
    protected static String scriptFile;
    protected static final String FLAGFILE_DEFAULT = "/tmp/flagFile";
    protected static Path flagFile;
    protected String hostname;
    private static final String USAGE_CMD = "java LoadGenerator\n";
    protected static final String USAGE_ARGS = "-readProbability <read probability>\n-writeProbability <write probability>\n-root <root>\n-maxDelayBetweenOps <maxDelayBetweenOpsInMillis>\n-numOfThreads <numOfThreads>\n-elapsedTime <elapsedTimeInSecs>\n-startTime <startTimeInMillis>\n-scriptFile <filename>\n-flagFile <filename>";
    private static final String USAGE = "java LoadGenerator\n-readProbability <read probability>\n-writeProbability <write probability>\n-root <root>\n-maxDelayBetweenOps <maxDelayBetweenOpsInMillis>\n-numOfThreads <numOfThreads>\n-elapsedTime <elapsedTimeInSecs>\n-startTime <startTimeInMillis>\n-scriptFile <filename>\n-flagFile <filename>";
    private final byte[] WRITE_CONTENTS = new byte[4096];
    private static final int ERR_TEST_FAILED = 2;
    protected static final int OPEN = 0;
    protected static final int LIST = 1;
    protected static final int CREATE = 2;
    protected static final int WRITE_CLOSE = 3;
    protected static final int DELETE = 4;
    protected static final int TOTAL_OP_TYPES = 5;
    protected static long[] executionTime;
    protected static long[] numOfOps;
    protected static long totalOps;

    public LoadGenerator() throws IOException, UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        this.hostname = addr.getHostName();
        Arrays.fill(this.WRITE_CONTENTS, (byte)97);
    }

    public LoadGenerator(Configuration conf) throws IOException, UnknownHostException {
        this();
        this.setConf(conf);
    }

    public int run(String[] args) throws Exception {
        int exitCode = this.parseArgs(false, args);
        if (exitCode != 0) {
            return exitCode;
        }
        System.out.println("Running LoadGenerator against fileSystem: " + FileContext.getFileContext().getDefaultFileSystem().getUri());
        exitCode = this.generateLoadOnNN();
        LoadGenerator.printResults(System.out);
        return exitCode;
    }

    boolean stopFileCreated() {
        try {
            fc.getFileStatus(flagFile);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            LOG.error("Got error when checking if file exists:" + flagFile, (Throwable)e);
        }
        LOG.info("Flag file was created. Stopping the test.");
        return true;
    }

    protected int generateLoadOnNN() throws InterruptedException {
        int hostHashCode = this.hostname.hashCode();
        r = seed == 0L ? new Random(System.currentTimeMillis() + (long)hostHashCode) : new Random(seed + (long)hostHashCode);
        try {
            fc = FileContext.getFileContext((Configuration)this.getConf());
        }
        catch (IOException ioe) {
            System.err.println("Can not initialize the file system: " + ioe.getLocalizedMessage());
            return -1;
        }
        int status = this.initFileDirTables();
        if (status != 0) {
            return status;
        }
        LoadGenerator.barrier();
        DFSClientThread[] threads = new DFSClientThread[numOfThreads];
        for (int i = 0; i < numOfThreads; ++i) {
            threads[i] = new DFSClientThread(i);
            threads[i].start();
        }
        if (durations[0] > 0L) {
            if (durations.length == 1) {
                while (shouldRun) {
                    Thread.sleep(2000L);
                    if ((totalTime += 2L) < durations[0] && !this.stopFileCreated()) continue;
                    shouldRun = false;
                }
            } else {
                while (shouldRun) {
                    Thread.sleep(durations[currentIndex] * 1000L);
                    totalTime += durations[currentIndex];
                    if (currentIndex + 1 == durations.length || this.stopFileCreated()) {
                        shouldRun = false;
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Moving to index " + currentIndex + ": r = " + readProbs[currentIndex] + ", w = " + writeProbs + " for duration " + durations[currentIndex]);
                    }
                    ++currentIndex;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done with testing.  Waiting for threads to finish.");
        }
        boolean failed = false;
        for (DFSClientThread thread : threads) {
            thread.join();
            for (int i = 0; i < 5; ++i) {
                int n = i;
                executionTime[n] = executionTime[n] + thread.executionTime[i];
                int n2 = i;
                numOfOps[n2] = numOfOps[n2] + thread.totalNumOfOps[i];
            }
            failed = failed || thread.failed;
        }
        int exitCode = 0;
        if (failed) {
            exitCode = -2;
        }
        totalOps = 0L;
        for (int i = 0; i < 5; ++i) {
            totalOps += numOfOps[i];
        }
        return exitCode;
    }

    protected static void printResults(PrintStream out) throws UnsupportedFileSystemException {
        out.println("Result of running LoadGenerator against fileSystem: " + FileContext.getFileContext().getDefaultFileSystem().getUri());
        if (numOfOps[0] != 0L) {
            out.println("Average open execution time: " + (double)executionTime[0] / (double)numOfOps[0] + "ms");
        }
        if (numOfOps[1] != 0L) {
            out.println("Average list execution time: " + (double)executionTime[1] / (double)numOfOps[1] + "ms");
        }
        if (numOfOps[4] != 0L) {
            out.println("Average deletion execution time: " + (double)executionTime[4] / (double)numOfOps[4] + "ms");
            out.println("Average create execution time: " + (double)executionTime[2] / (double)numOfOps[2] + "ms");
            out.println("Average write_close execution time: " + (double)executionTime[3] / (double)numOfOps[3] + "ms");
        }
        if (totalTime != 0L) {
            out.println("Average operations per second: " + (double)totalOps / (double)totalTime + "ops/s");
        }
        out.println();
    }

    protected int parseArgs(boolean runAsMapReduce, String[] args) throws IOException {
        int i;
        try {
            for (i = 0; i < args.length; ++i) {
                if (args[i].equals("-scriptFile")) {
                    scriptFile = args[++i];
                    if (durations[0] <= 0L) continue;
                    System.err.println("Can't specify elapsedTime and use script.");
                    return -1;
                }
                if (args[i].equals("-readProbability")) {
                    if (scriptFile != null) {
                        System.err.println("Can't specify probabilities and use script.");
                        return -1;
                    }
                    LoadGenerator.readProbs[0] = Double.parseDouble(args[++i]);
                    if (!(readProbs[0] < 0.0) && !(readProbs[0] > 1.0)) continue;
                    System.err.println("The read probability must be [0, 1]: " + readProbs[0]);
                    return -1;
                }
                if (args[i].equals("-writeProbability")) {
                    if (scriptFile != null) {
                        System.err.println("Can't specify probabilities and use script.");
                        return -1;
                    }
                    LoadGenerator.writeProbs[0] = Double.parseDouble(args[++i]);
                    if (!(writeProbs[0] < 0.0) && !(writeProbs[0] > 1.0)) continue;
                    System.err.println("The write probability must be [0, 1]: " + writeProbs[0]);
                    return -1;
                }
                if (args[i].equals("-root")) {
                    root = new Path(args[++i]);
                    continue;
                }
                if (args[i].equals("-maxDelayBetweenOps")) {
                    maxDelayBetweenOps = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-numOfThreads")) {
                    if ((numOfThreads = Integer.parseInt(args[++i])) > 0) continue;
                    System.err.println("Number of threads must be positive: " + numOfThreads);
                    return -1;
                }
                if (args[i].equals("-startTime")) {
                    startTime = Long.parseLong(args[++i]);
                    continue;
                }
                if (args[i].equals("-elapsedTime")) {
                    if (scriptFile != null) {
                        System.err.println("Can't specify elapsedTime and use script.");
                        return -1;
                    }
                    LoadGenerator.durations[0] = Long.parseLong(args[++i]);
                    continue;
                }
                if (args[i].equals("-seed")) {
                    seed = Long.parseLong(args[++i]);
                    r = new Random(seed);
                    continue;
                }
                if (args[i].equals("-flagFile")) {
                    LOG.info("got flagFile:" + flagFile);
                    flagFile = new Path(args[++i]);
                    continue;
                }
                System.err.println(USAGE);
                ToolRunner.printGenericCommandUsage((PrintStream)System.err);
                return -1;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Illegal parameter: " + e.getLocalizedMessage());
            System.err.println(USAGE);
            return -1;
        }
        if (!runAsMapReduce && scriptFile != null && LoadGenerator.loadScriptFile(scriptFile, true) == -1) {
            return -1;
        }
        for (i = 0; i < readProbs.length; ++i) {
            if (!(readProbs[i] + writeProbs[i] < 0.0) && !(readProbs[i] + writeProbs[i] > 1.0)) continue;
            System.err.println("The sum of read probability and write probability must be [0, 1]: " + readProbs[i] + " " + writeProbs[i]);
            return -1;
        }
        return 0;
    }

    private static void parseScriptLine(String line, ArrayList<Long> duration, ArrayList<Double> readProb, ArrayList<Double> writeProb) {
        String[] a = line.split("\\s");
        if (a.length != 3) {
            throw new IllegalArgumentException("Incorrect number of parameters: " + line);
        }
        try {
            long d = Long.parseLong(a[0]);
            double r = Double.parseDouble(a[1]);
            double w = Double.parseDouble(a[2]);
            Preconditions.checkArgument((d >= 0L ? 1 : 0) != 0, (Object)("Invalid duration: " + d));
            Preconditions.checkArgument((0.0 <= r && r <= 1.0 ? 1 : 0) != 0, (Object)("The read probability must be [0, 1]: " + r));
            Preconditions.checkArgument((0.0 <= w && w <= 1.0 ? 1 : 0) != 0, (Object)("The read probability must be [0, 1]: " + w));
            readProb.add(r);
            duration.add(d);
            writeProb.add(w);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Cannot parse: " + line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int loadScriptFile(String filename, boolean readLocally) throws IOException {
        FileContext fc = readLocally ? FileContext.getLocalFSFileContext() : FileContext.getFileContext();
        FSDataInputStream in = null;
        try {
            in = fc.open(new Path(filename));
        }
        catch (IOException e) {
            System.err.println("Unable to open scriptFile: " + filename);
            System.exit(-1);
        }
        InputStreamReader inr = new InputStreamReader((InputStream)in);
        BufferedReader br = new BufferedReader(inr);
        ArrayList<Long> duration = new ArrayList<Long>();
        ArrayList<Double> readProb = new ArrayList<Double>();
        ArrayList<Double> writeProb = new ArrayList<Double>();
        int lineNum = 0;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ++lineNum;
                if (line.startsWith("#") || line.isEmpty()) continue;
                LoadGenerator.parseScriptLine(line, duration, readProb, writeProb);
            }
        }
        catch (IllegalArgumentException e) {
            int n;
            try {
                System.err.println("Line: " + lineNum + ", " + e.getMessage());
                n = -1;
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{br});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{br});
            return n;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{br});
        durations = new long[duration.size()];
        readProbs = new double[readProb.size()];
        writeProbs = new double[writeProb.size()];
        for (int i = 0; i < durations.length; ++i) {
            LoadGenerator.durations[i] = duration.get(i);
            LoadGenerator.readProbs[i] = readProb.get(i);
            LoadGenerator.writeProbs[i] = writeProb.get(i);
        }
        if (durations[0] == 0L) {
            System.err.println("Initial duration set to 0.  Will loop until stopped manually.");
        }
        return 0;
    }

    private int initFileDirTables() {
        try {
            this.initFileDirTables(root);
        }
        catch (IOException e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return -1;
        }
        if (dirs.isEmpty()) {
            System.err.println("The test space " + root + " is empty");
            return -1;
        }
        if (files.isEmpty()) {
            System.err.println("The test space " + root + " does not have any file");
            return -1;
        }
        return 0;
    }

    private void initFileDirTables(Path path) throws IOException {
        FileStatus[] stats;
        for (FileStatus stat : stats = fc.util().listStatus(path)) {
            if (stat.isDirectory()) {
                dirs.add(stat.getPath().toString());
                this.initFileDirTables(stat.getPath());
                continue;
            }
            Path filePath = stat.getPath();
            if (!filePath.getName().startsWith("_file_")) continue;
            files.add(filePath.toString());
        }
    }

    private static void barrier() {
        long sleepTime;
        while ((sleepTime = startTime - Time.now()) > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new LoadGenerator(), (String[])args);
        System.exit(res);
    }

    static {
        maxDelayBetweenOps = 0;
        numOfThreads = 200;
        durations = new long[]{0L};
        readProbs = new double[]{0.3333};
        writeProbs = new double[]{0.3333};
        currentIndex = 0;
        totalTime = 0L;
        startTime = Time.now() + 10000L;
        files = new ArrayList();
        dirs = new ArrayList();
        r = null;
        seed = 0L;
        scriptFile = null;
        flagFile = new Path(FLAGFILE_DEFAULT);
        executionTime = new long[5];
        numOfOps = new long[5];
        totalOps = 0L;
    }

    private class DFSClientThread
    extends Thread {
        private int id;
        private long[] executionTime = new long[5];
        private long[] totalNumOfOps = new long[5];
        private byte[] buffer = new byte[1024];
        private boolean failed;

        private DFSClientThread(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            try {
                while (shouldRun) {
                    this.nextOp();
                    this.delay();
                }
            }
            catch (Exception ioe) {
                System.err.println(ioe.getLocalizedMessage());
                ioe.printStackTrace();
                this.failed = true;
            }
        }

        private void delay() throws InterruptedException {
            if (maxDelayBetweenOps > 0) {
                int delay = r.nextInt(maxDelayBetweenOps);
                Thread.sleep(delay);
            }
        }

        private void nextOp() throws IOException {
            double rn = r.nextDouble();
            int i = currentIndex;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Thread " + this.id + " moving to index " + i);
            }
            if (rn < readProbs[i]) {
                this.read();
            } else if (rn < readProbs[i] + writeProbs[i]) {
                this.write();
            } else {
                this.list();
            }
        }

        private void read() throws IOException {
            String fileName = (String)files.get(r.nextInt(files.size()));
            long startTimestamp = Time.monotonicNow();
            FSDataInputStream in = fc.open(new Path(fileName));
            this.executionTime[0] = this.executionTime[0] + (Time.monotonicNow() - startTimestamp);
            this.totalNumOfOps[0] = this.totalNumOfOps[0] + 1L;
            while (in.read(this.buffer) != -1) {
            }
            in.close();
        }

        private void write() throws IOException {
            double d;
            String dirName = (String)dirs.get(r.nextInt(dirs.size()));
            Path file = new Path(dirName, LoadGenerator.this.hostname + this.id + UUID.randomUUID().toString());
            double fileSize = 0.0;
            do {
                fileSize = r.nextGaussian() + 2.0;
            } while (d <= 0.0);
            this.genFile(file, (long)(fileSize * 10.0));
            long startTimestamp = Time.monotonicNow();
            fc.delete(file, true);
            this.executionTime[4] = this.executionTime[4] + (Time.monotonicNow() - startTimestamp);
            this.totalNumOfOps[4] = this.totalNumOfOps[4] + 1L;
        }

        private void list() throws IOException {
            String dirName = (String)dirs.get(r.nextInt(dirs.size()));
            long startTimestamp = Time.monotonicNow();
            fc.listStatus(new Path(dirName));
            this.executionTime[1] = this.executionTime[1] + (Time.monotonicNow() - startTimestamp);
            this.totalNumOfOps[1] = this.totalNumOfOps[1] + 1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void genFile(Path file, long fileSize) throws IOException {
            long startTimestamp = Time.monotonicNow();
            FSDataOutputStream out = null;
            boolean isOutClosed = false;
            try {
                long s;
                out = fc.create(file, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[]{Options.CreateOpts.createParent(), Options.CreateOpts.bufferSize((int)4096), Options.CreateOpts.repFac((short)3)});
                this.executionTime[2] = this.executionTime[2] + (Time.monotonicNow() - startTimestamp);
                numOfOps[2] = numOfOps[2] + 1L;
                for (long i = fileSize; i > 0L; i -= s) {
                    s = Math.min(fileSize, (long)LoadGenerator.this.WRITE_CONTENTS.length);
                    out.write(LoadGenerator.this.WRITE_CONTENTS, 0, (int)s);
                }
                startTime = Time.monotonicNow();
                out.close();
                this.executionTime[3] = this.executionTime[3] + (Time.monotonicNow() - startTime);
                numOfOps[3] = numOfOps[3] + 1L;
                isOutClosed = true;
            }
            finally {
                if (!isOutClosed && out != null) {
                    out.close();
                }
            }
        }
    }
}

