/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.matchers;

import java.io.Serializable;
import org.apache.hadoop.shaded.org.mockito.ArgumentMatcher;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.ContainsExtraTypeInfo;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.Equality;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.text.ValuePrinter;

public class Equals
implements ArgumentMatcher<Object>,
ContainsExtraTypeInfo,
Serializable {
    private final Object wanted;

    public Equals(Object wanted) {
        this.wanted = wanted;
    }

    @Override
    public boolean matches(Object actual) {
        return Equality.areEqual(this.wanted, actual);
    }

    public String toString() {
        return this.describe(this.wanted);
    }

    private String describe(Object object) {
        return ValuePrinter.print(object);
    }

    protected final Object getWanted() {
        return this.wanted;
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Equals other = (Equals)o;
        return this.wanted == null && other.wanted == null || this.wanted != null && this.wanted.equals(other.wanted);
    }

    public int hashCode() {
        return 1;
    }

    @Override
    public String toStringWithType() {
        return "(" + this.wanted.getClass().getSimpleName() + ") " + this.describe(this.wanted);
    }

    @Override
    public boolean typeMatches(Object target) {
        return this.wanted != null && target != null && target.getClass() == this.wanted.getClass();
    }
}

