/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.server.api.ContainerLogContext;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation.AppLogAggregator;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation.AppLogAggregatorImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.LogHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerAppFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerAppStartedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerContainerFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAggregationService
extends AbstractService
implements LogHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LogAggregationService.class);
    private static final long MIN_LOG_ROLLING_INTERVAL = 3600L;
    private static final String NM_LOG_AGGREGATION_DEBUG_ENABLED = "yarn.nodemanager.log-aggregation.debug-enabled";
    private long rollingMonitorInterval;
    private final Context context;
    private final DeletionService deletionService;
    private final Dispatcher dispatcher;
    private LocalDirsHandlerService dirsHandler;
    private NodeId nodeId;
    private final ConcurrentMap<ApplicationId, AppLogAggregator> appLogAggregators;
    @VisibleForTesting
    ExecutorService threadPool;

    public LogAggregationService(Dispatcher dispatcher, Context context, DeletionService deletionService, LocalDirsHandlerService dirsHandler) {
        super(LogAggregationService.class.getName());
        this.dispatcher = dispatcher;
        this.context = context;
        this.deletionService = deletionService;
        this.dirsHandler = dirsHandler;
        this.appLogAggregators = new ConcurrentHashMap<ApplicationId, AppLogAggregator>();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        int threadPoolSize = this.getAggregatorThreadPoolSize(conf);
        this.threadPool = HadoopExecutors.newFixedThreadPool((int)threadPoolSize, (ThreadFactory)new ThreadFactoryBuilder().setNameFormat("LogAggregationService #%d").build());
        this.rollingMonitorInterval = conf.getLong("yarn.nodemanager.log-aggregation.roll-monitoring-interval-seconds", -1L);
        boolean logAggregationDebugMode = conf.getBoolean(NM_LOG_AGGREGATION_DEBUG_ENABLED, false);
        if (this.rollingMonitorInterval > 0L && this.rollingMonitorInterval < 3600L) {
            if (logAggregationDebugMode) {
                LOG.info("Log aggregation debug mode enabled. rollingMonitorInterval = " + this.rollingMonitorInterval);
            } else {
                LOG.warn("rollingMonitorIntervall should be more than or equal to 3600 seconds. Using 3600 seconds instead.");
                this.rollingMonitorInterval = 3600L;
            }
        } else if (this.rollingMonitorInterval <= 0L) {
            LOG.info("rollingMonitorInterval is set as " + this.rollingMonitorInterval + ". The log rolling monitoring interval is disabled. " + "The logs will be aggregated after this application is finished.");
        } else {
            LOG.info("rollingMonitorInterval is set as " + this.rollingMonitorInterval + ". The logs will be aggregated every " + this.rollingMonitorInterval + " seconds");
        }
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.nodeId = this.context.getNodeId();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        LOG.info(this.getName() + " waiting for pending aggregation during exit");
        this.stopAggregators();
        super.serviceStop();
    }

    private void stopAggregators() {
        this.threadPool.shutdown();
        boolean supervised = this.getConfig().getBoolean("yarn.nodemanager.recovery.supervised", false);
        boolean shouldAbort = this.context.getNMStateStore().canRecover() && !this.context.getDecommissioned() && supervised;
        for (AppLogAggregator aggregator : this.appLogAggregators.values()) {
            if (shouldAbort) {
                aggregator.abortLogAggregation();
                continue;
            }
            aggregator.finishLogAggregation();
        }
        while (!this.threadPool.isTerminated()) {
            for (ApplicationId appId : this.appLogAggregators.keySet()) {
                LOG.info("Waiting for aggregation to complete for " + appId);
            }
            try {
                if (this.threadPool.awaitTermination(30L, TimeUnit.SECONDS)) continue;
                this.threadPool.shutdownNow();
            }
            catch (InterruptedException e) {
                LOG.warn("Aggregation stop interrupted!");
                break;
            }
        }
        for (ApplicationId appId : this.appLogAggregators.keySet()) {
            LOG.warn("Some logs may not have been aggregated for " + appId);
        }
    }

    private void initApp(ApplicationId appId, String user, Credentials credentials, Map<ApplicationAccessType, String> appAcls, LogAggregationContext logAggregationContext, long recoveredLogInitedTime) {
        ApplicationEvent eventResponse;
        try {
            this.initAppAggregator(appId, user, credentials, appAcls, logAggregationContext, recoveredLogInitedTime);
            eventResponse = new ApplicationEvent(appId, ApplicationEventType.APPLICATION_LOG_HANDLING_INITED);
        }
        catch (YarnRuntimeException e) {
            LOG.warn("Application failed to init aggregation", (Throwable)e);
            eventResponse = new ApplicationEvent(appId, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED);
        }
        this.dispatcher.getEventHandler().handle((Event)eventResponse);
    }

    FileContext getLocalFileContext(Configuration conf) {
        try {
            return FileContext.getLocalFSFileContext((Configuration)conf);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to access local fs");
        }
    }

    protected void initAppAggregator(final ApplicationId appId, String user, Credentials credentials, Map<ApplicationAccessType, String> appAcls, LogAggregationContext logAggregationContext, long recoveredLogInitedTime) {
        final UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)user);
        if (credentials != null) {
            userUgi.addCredentials(credentials);
        }
        LogAggregationFileController logAggregationFileController = this.getLogAggregationFileController(this.getConfig());
        logAggregationFileController.verifyAndCreateRemoteLogDir();
        final AppLogAggregatorImpl appLogAggregator = new AppLogAggregatorImpl(this.dispatcher, this.deletionService, this.getConfig(), appId, userUgi, this.nodeId, this.dirsHandler, logAggregationFileController.getRemoteNodeLogFileForApp(appId, user, this.nodeId), appAcls, logAggregationContext, this.context, this.getLocalFileContext(this.getConfig()), this.rollingMonitorInterval, recoveredLogInitedTime, logAggregationFileController);
        if (this.appLogAggregators.putIfAbsent(appId, appLogAggregator) != null) {
            throw new YarnRuntimeException("Duplicate initApp for " + appId);
        }
        YarnRuntimeException appDirException = null;
        try {
            logAggregationFileController.createAppDir(user, appId, userUgi);
        }
        catch (Exception e) {
            appLogAggregator.disableLogAggregation();
            appDirException = !(e instanceof YarnRuntimeException) ? new YarnRuntimeException((Throwable)e) : (YarnRuntimeException)((Object)e);
            this.appLogAggregators.remove(appId);
            this.closeFileSystems(userUgi);
            throw appDirException;
        }
        Runnable aggregatorWrapper = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    appLogAggregator.run();
                }
                finally {
                    LogAggregationService.this.appLogAggregators.remove(appId);
                    LogAggregationService.this.closeFileSystems(userUgi);
                }
            }
        };
        this.threadPool.execute(aggregatorWrapper);
    }

    protected void closeFileSystems(UserGroupInformation userUgi) {
        try {
            FileSystem.closeAllForUGI((UserGroupInformation)userUgi);
        }
        catch (IOException e) {
            LOG.warn("Failed to close filesystems: ", (Throwable)e);
        }
    }

    @InterfaceAudience.Private
    int getNumAggregators() {
        return this.appLogAggregators.size();
    }

    private void stopContainer(ContainerId containerId, ContainerType containerType, int exitCode) {
        AppLogAggregator aggregator = (AppLogAggregator)this.appLogAggregators.get(containerId.getApplicationAttemptId().getApplicationId());
        if (aggregator == null) {
            LOG.warn("Log aggregation is not initialized for " + containerId + ", did it fail to start?");
            return;
        }
        aggregator.startContainerLogAggregation(new ContainerLogContext(containerId, containerType, exitCode));
    }

    private void stopApp(ApplicationId appId) {
        AppLogAggregator aggregator = (AppLogAggregator)this.appLogAggregators.get(appId);
        if (aggregator == null) {
            LOG.warn("Log aggregation is not initialized for " + appId + ", did it fail to start?");
            this.dispatcher.getEventHandler().handle((Event)new ApplicationEvent(appId, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED));
            return;
        }
        aggregator.finishLogAggregation();
    }

    @Override
    public void handle(LogHandlerEvent event) {
        switch ((LogHandlerEventType)event.getType()) {
            case APPLICATION_STARTED: {
                LogHandlerAppStartedEvent appStartEvent = (LogHandlerAppStartedEvent)event;
                this.initApp(appStartEvent.getApplicationId(), appStartEvent.getUser(), appStartEvent.getCredentials(), appStartEvent.getApplicationAcls(), appStartEvent.getLogAggregationContext(), appStartEvent.getRecoveredAppLogInitedTime());
                break;
            }
            case CONTAINER_FINISHED: {
                LogHandlerContainerFinishedEvent containerFinishEvent = (LogHandlerContainerFinishedEvent)event;
                this.stopContainer(containerFinishEvent.getContainerId(), containerFinishEvent.getContainerType(), containerFinishEvent.getExitCode());
                break;
            }
            case APPLICATION_FINISHED: {
                LogHandlerAppFinishedEvent appFinishedEvent = (LogHandlerAppFinishedEvent)event;
                this.stopApp(appFinishedEvent.getApplicationId());
                break;
            }
        }
    }

    @VisibleForTesting
    public ConcurrentMap<ApplicationId, AppLogAggregator> getAppLogAggregators() {
        return this.appLogAggregators;
    }

    @VisibleForTesting
    public NodeId getNodeId() {
        return this.nodeId;
    }

    private int getAggregatorThreadPoolSize(Configuration conf) {
        int threadPoolSize;
        try {
            threadPoolSize = conf.getInt("yarn.nodemanager.logaggregation.threadpool-size-max", 100);
        }
        catch (NumberFormatException ex) {
            LOG.warn("Invalid thread pool size. Setting it to the default value in YarnConfiguration");
            threadPoolSize = 100;
        }
        if (threadPoolSize <= 0) {
            LOG.warn("Invalid thread pool size. Setting it to the default value in YarnConfiguration");
            threadPoolSize = 100;
        }
        return threadPoolSize;
    }

    @VisibleForTesting
    public LogAggregationFileController getLogAggregationFileController(Configuration conf) {
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(conf);
        LogAggregationFileController logAggregationFileController = factory.getFileControllerForWrite();
        return logAggregationFileController;
    }
}

