/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.HBaseClusterManager;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.ShellExecEndpoint;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CoprocClusterManager
extends HBaseClusterManager {
    private static final Logger LOG = LoggerFactory.getLogger(CoprocClusterManager.class);
    private static final Set<ClusterManager.ServiceType> supportedServices = CoprocClusterManager.buildSupportedServicesSet();

    @Override
    protected Pair<Integer, String> exec(String hostname, ClusterManager.ServiceType service, String ... cmd) throws IOException {
        if (!supportedServices.contains((Object)service)) {
            throw CoprocClusterManager.unsupportedServiceType(service);
        }
        String command = StringUtils.join((Object[])cmd, (String)" ");
        LOG.info("Executing remote command: {}, hostname:{}", (Object)command, (Object)hostname);
        try (AsyncConnection conn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)this.getConf()).join();){
            ShellExecEndpoint.ShellExecResponse resp;
            AsyncAdmin admin = conn.getAdmin();
            ShellExecEndpoint.ShellExecRequest req = ShellExecEndpoint.ShellExecRequest.newBuilder().setCommand(command).setAwaitResponse(false).build();
            switch (service) {
                case HBASE_MASTER: {
                    resp = CoprocClusterManager.masterExec(admin, req);
                    break;
                }
                case HBASE_REGIONSERVER: {
                    ServerName targetHost = CoprocClusterManager.resolveRegionServerName(admin, hostname);
                    resp = CoprocClusterManager.regionServerExec(admin, req, targetHost);
                    break;
                }
                default: {
                    throw new RuntimeException("should not happen");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executed remote command: {}, exit code:{} , output:{}", new Object[]{command, resp.getExitCode(), resp.getStdout()});
            } else {
                LOG.info("Executed remote command: {}, exit code:{}", (Object)command, (Object)resp.getExitCode());
            }
            Pair pair = new Pair((Object)resp.getExitCode(), (Object)resp.getStdout());
            return pair;
        }
    }

    private static Set<ClusterManager.ServiceType> buildSupportedServicesSet() {
        HashSet<ClusterManager.ServiceType> set = new HashSet<ClusterManager.ServiceType>();
        set.add(ClusterManager.ServiceType.HBASE_MASTER);
        set.add(ClusterManager.ServiceType.HBASE_REGIONSERVER);
        return Collections.unmodifiableSet(set);
    }

    private static ShellExecEndpoint.ShellExecResponse masterExec(AsyncAdmin admin, ShellExecEndpoint.ShellExecRequest req) {
        return (ShellExecEndpoint.ShellExecResponse)admin.coprocessorService(ShellExecEndpoint.ShellExecService::newStub, (stub, controller, callback) -> stub.shellExec(controller, req, callback)).join();
    }

    private static ShellExecEndpoint.ShellExecResponse regionServerExec(AsyncAdmin admin, ShellExecEndpoint.ShellExecRequest req, ServerName targetHost) {
        return (ShellExecEndpoint.ShellExecResponse)admin.coprocessorService(ShellExecEndpoint.ShellExecService::newStub, (stub, controller, callback) -> stub.shellExec(controller, req, callback), targetHost).join();
    }

    private static ServerName resolveRegionServerName(AsyncAdmin admin, String hostname) {
        return (ServerName)((Optional)((CompletableFuture)admin.getRegionServers().thenApply(names -> names.stream().filter(sn -> Objects.equals(sn.getHostname(), hostname)).findAny())).join()).orElseThrow(() -> CoprocClusterManager.serverNotFound(hostname));
    }

    private static RuntimeException serverNotFound(String hostname) {
        return new RuntimeException(String.format("Did not find %s amongst the servers known to the client.", hostname));
    }

    private static RuntimeException unsupportedServiceType(ClusterManager.ServiceType serviceType) {
        return new RuntimeException(String.format("Unable to service request for service=%s", new Object[]{serviceType}));
    }
}

