/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeBloomFilterAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeBloomFilterAction.class);
    private final TableName tableName;

    public ChangeBloomFilterAction(TableName tableName) {
        this.tableName = tableName;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        BloomType[] bloomArray = BloomType.values();
        int bloomArraySize = bloomArray.length;
        this.getLogger().info("Performing action: Change bloom filter on all columns of table " + this.tableName);
        this.modifyAllTableColumns(this.tableName, (String columnName, ColumnFamilyDescriptorBuilder columnBuilder) -> {
            BloomType bloomType = bloomArray[ThreadLocalRandom.current().nextInt(bloomArraySize)];
            this.getLogger().debug("Performing action: About to set bloom filter type to " + bloomType + " on column " + columnName + " of table " + this.tableName);
            columnBuilder.setBloomFilterType(bloomType);
            if (bloomType == BloomType.ROWPREFIX_FIXED_LENGTH) {
                columnBuilder.setConfiguration("RowPrefixBloomFilter.prefix_length", "10");
            }
        });
        this.getLogger().debug("Performing action: Just set bloom filter types on table " + this.tableName);
    }
}

