/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.MultiQuery;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlStatementInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlStatementSanitizerUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.Collection;

public final class SqlClientAttributesExtractor<REQUEST, RESPONSE>
extends DbClientCommonAttributesExtractor<REQUEST, RESPONSE, SqlClientAttributesGetter<REQUEST, RESPONSE>> {
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey("db.operation");
    private static final AttributeKey<String> DB_OPERATION_NAME = AttributeKey.stringKey("db.operation.name");
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey("db.statement");
    private static final AttributeKey<String> DB_QUERY_TEXT = AttributeKey.stringKey("db.query.text");
    static final AttributeKey<String> DB_COLLECTION_NAME = AttributeKey.stringKey("db.collection.name");
    private static final AttributeKey<Long> DB_OPERATION_BATCH_SIZE = AttributeKey.longKey("db.operation.batch.size");
    private static final String SQL_CALL = "CALL";
    private final AttributeKey<String> oldSemconvTableAttribute;
    private final boolean statementSanitizationEnabled;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return SqlClientAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(SqlClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE>(getter);
    }

    SqlClientAttributesExtractor(SqlClientAttributesGetter<REQUEST, RESPONSE> getter, AttributeKey<String> oldSemconvTableAttribute, boolean statementSanitizationEnabled) {
        super(getter);
        this.oldSemconvTableAttribute = oldSemconvTableAttribute;
        this.statementSanitizationEnabled = statementSanitizationEnabled;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        Collection<String> rawQueryTexts = ((SqlClientAttributesGetter)this.getter).getRawQueryTexts(request);
        if (rawQueryTexts.isEmpty()) {
            return;
        }
        if (SemconvStability.emitOldDatabaseSemconv() && rawQueryTexts.size() == 1) {
            String rawQueryText = rawQueryTexts.iterator().next();
            SqlStatementInfo sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryText);
            String operation = sanitizedStatement.getOperation();
            AttributesExtractorUtil.internalSet(attributes, DB_STATEMENT, this.statementSanitizationEnabled ? sanitizedStatement.getFullStatement() : rawQueryText);
            AttributesExtractorUtil.internalSet(attributes, DB_OPERATION, operation);
            if (!SQL_CALL.equals(operation)) {
                AttributesExtractorUtil.internalSet(attributes, this.oldSemconvTableAttribute, sanitizedStatement.getMainIdentifier());
            }
        }
        if (SemconvStability.emitStableDatabaseSemconv()) {
            boolean isBatch;
            Long batchSize = ((SqlClientAttributesGetter)this.getter).getBatchSize(request);
            boolean bl = isBatch = batchSize != null && batchSize > 1L;
            if (isBatch) {
                AttributesExtractorUtil.internalSet(attributes, DB_OPERATION_BATCH_SIZE, batchSize);
            }
            if (rawQueryTexts.size() == 1) {
                String rawQueryText = rawQueryTexts.iterator().next();
                SqlStatementInfo sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryText);
                String operation = sanitizedStatement.getOperation();
                AttributesExtractorUtil.internalSet(attributes, DB_QUERY_TEXT, this.statementSanitizationEnabled ? sanitizedStatement.getFullStatement() : rawQueryText);
                AttributesExtractorUtil.internalSet(attributes, DB_OPERATION_NAME, isBatch ? "BATCH " + operation : operation);
                if (!SQL_CALL.equals(operation)) {
                    AttributesExtractorUtil.internalSet(attributes, DB_COLLECTION_NAME, sanitizedStatement.getMainIdentifier());
                }
            } else {
                MultiQuery multiQuery = MultiQuery.analyze(((SqlClientAttributesGetter)this.getter).getRawQueryTexts(request), this.statementSanitizationEnabled);
                AttributesExtractorUtil.internalSet(attributes, DB_QUERY_TEXT, SqlClientAttributesExtractor.join("; ", multiQuery.getStatements()));
                String operation = multiQuery.getOperation() != null ? "BATCH " + multiQuery.getOperation() : "BATCH";
                AttributesExtractorUtil.internalSet(attributes, DB_OPERATION_NAME, operation);
                if (!(multiQuery.getMainIdentifier() == null || multiQuery.getOperation() != null && SQL_CALL.equals(multiQuery.getOperation()))) {
                    AttributesExtractorUtil.internalSet(attributes, DB_COLLECTION_NAME, multiQuery.getMainIdentifier());
                }
            }
        }
    }

    private static String join(String delimiter, Collection<String> collection) {
        StringBuilder builder = new StringBuilder();
        for (String string : collection) {
            if (builder.length() != 0) {
                builder.append(delimiter);
            }
            builder.append(string);
        }
        return builder.toString();
    }
}

