/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.sp.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.util.MethodUtils;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.sp.StoredProcEngine;
import org.apache.directory.server.core.api.sp.StoredProcUtils;
import org.apache.directory.server.core.api.sp.java.LdapJavaStoredProcClassLoader;

public class JavaStoredProcEngine
implements StoredProcEngine {
    public static final String STORED_PROC_LANG_ID = "Java";
    private Entry spUnit;
    private static Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    @Override
    public Object invokeProcedure(CoreSession session, String fullSPName, Object[] spArgs) throws LdapException {
        Method proc;
        Class<?> clazz;
        Attribute javaByteCode = this.spUnit.get("javaByteCode");
        String spName = StoredProcUtils.extractStoredProcName(fullSPName);
        String className = StoredProcUtils.extractStoredProcUnitName(fullSPName);
        LdapJavaStoredProcClassLoader loader = new LdapJavaStoredProcClassLoader(javaByteCode);
        try {
            clazz = loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new LdapException((Throwable)e);
        }
        Class[] types = this.getTypesFromValues(spArgs);
        try {
            proc = MethodUtils.getAssignmentCompatibleMethod(clazz, (String)spName, (Class[])types);
        }
        catch (NoSuchMethodException e) {
            throw new LdapException((Throwable)e);
        }
        try {
            return proc.invoke(null, spArgs);
        }
        catch (IllegalArgumentException e) {
            throw new LdapException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new LdapException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new LdapException((Throwable)e);
        }
    }

    @Override
    public String getSPLangId() {
        return STORED_PROC_LANG_ID;
    }

    @Override
    public void setSPUnitEntry(Entry spUnit) {
        this.spUnit = spUnit;
    }

    private Class<?>[] getTypesFromValues(Object[] values) {
        ArrayList types = new ArrayList();
        for (Object obj : values) {
            types.add(obj.getClass());
        }
        return types.toArray(EMPTY_CLASS_ARRAY);
    }
}

