/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.server.timeline.GenericObjectMapper;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeveldbUtils {
    private static final String BACKUP_EXT = ".backup-";
    private static final Logger LOG = LoggerFactory.getLogger(LeveldbUtils.class);
    public static final FsPermission LEVELDB_DIR_UMASK = FsPermission.createImmutable((short)448);

    public static boolean prefixMatches(byte[] prefix, int prefixlen, byte[] b) {
        if (b.length < prefixlen) {
            return false;
        }
        return WritableComparator.compareBytes((byte[])prefix, (int)0, (int)prefixlen, (byte[])b, (int)0, (int)prefixlen) == 0;
    }

    public static DB loadOrRepairLevelDb(JniDBFactory factory, Path dbPath, Options options) throws IOException {
        DB db;
        try {
            db = factory.open(new File(dbPath.toString()), options);
        }
        catch (IOException ioe) {
            File dbFile = new File(dbPath.toString());
            File dbBackupPath = new File(dbPath.toString() + BACKUP_EXT + Time.monotonicNow());
            LOG.warn("Incurred exception while loading LevelDb database. Backing up at " + dbBackupPath, (Throwable)ioe);
            FileUtils.copyDirectory((File)dbFile, (File)dbBackupPath);
            factory.repair(dbFile, options);
            db = factory.open(dbFile, options);
        }
        return db;
    }

    public static class KeyParser {
        private final byte[] b;
        private int offset;

        public KeyParser(byte[] b, int offset) {
            this.b = b;
            this.offset = offset;
        }

        public String getNextString() throws IOException {
            if (this.offset >= this.b.length) {
                throw new IOException("tried to read nonexistent string from byte array");
            }
            int i = 0;
            while (this.offset + i < this.b.length && this.b[this.offset + i] != 0) {
                ++i;
            }
            String s = new String(this.b, this.offset, i, StandardCharsets.UTF_8);
            this.offset = this.offset + i + 1;
            return s;
        }

        public void skipNextString() throws IOException {
            if (this.offset >= this.b.length) {
                throw new IOException("tried to read nonexistent string from byte array");
            }
            while (this.offset < this.b.length && this.b[this.offset] != 0) {
                ++this.offset;
            }
            ++this.offset;
        }

        public long getNextLong() throws IOException {
            if (this.offset + 8 >= this.b.length) {
                throw new IOException("byte array ran out when trying to read long");
            }
            long value = GenericObjectMapper.readReverseOrderedLong(this.b, this.offset);
            this.offset += 8;
            return value;
        }

        public int getOffset() {
            return this.offset;
        }

        public byte[] getRemainingBytes() {
            byte[] bytes = new byte[this.b.length - this.offset];
            System.arraycopy(this.b, this.offset, bytes, 0, this.b.length - this.offset);
            return bytes;
        }
    }

    public static class KeyBuilder {
        private static final int MAX_NUMBER_OF_KEY_ELEMENTS = 10;
        private byte[][] b;
        private boolean[] useSeparator;
        private int index;
        private int length;

        public KeyBuilder(int size) {
            this.b = new byte[size][];
            this.useSeparator = new boolean[size];
            this.index = 0;
            this.length = 0;
        }

        public static KeyBuilder newInstance() {
            return new KeyBuilder(10);
        }

        public static KeyBuilder newInstance(int size) {
            return new KeyBuilder(size);
        }

        public KeyBuilder add(String s) {
            return this.add(s.getBytes(StandardCharsets.UTF_8), true);
        }

        public KeyBuilder add(byte[] t) {
            return this.add(t, false);
        }

        public KeyBuilder add(byte[] t, boolean sep) {
            this.b[this.index] = t;
            this.useSeparator[this.index] = sep;
            this.length += t.length;
            if (sep) {
                ++this.length;
            }
            ++this.index;
            return this;
        }

        public byte[] getBytes() {
            int bytesLength = this.length;
            if (this.useSeparator[this.index - 1]) {
                bytesLength = this.length - 1;
            }
            byte[] bytes = new byte[bytesLength];
            int curPos = 0;
            for (int i = 0; i < this.index; ++i) {
                System.arraycopy(this.b[i], 0, bytes, curPos, this.b[i].length);
                curPos += this.b[i].length;
                if (i >= this.index - 1 || !this.useSeparator[i]) continue;
                bytes[curPos++] = 0;
            }
            return bytes;
        }

        public byte[] getBytesForLookup() {
            byte[] bytes = new byte[this.length];
            int curPos = 0;
            for (int i = 0; i < this.index; ++i) {
                System.arraycopy(this.b[i], 0, bytes, curPos, this.b[i].length);
                curPos += this.b[i].length;
                if (!this.useSeparator[i]) continue;
                bytes[curPos++] = 0;
            }
            return bytes;
        }
    }
}

