/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LazyPersistTestCase;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestLazyPersistReplicaRecovery
extends LazyPersistTestCase {
    @Test
    public void testDnRestartWithSavedReplicas() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().build();
        FSNamesystem fsn = this.cluster.getNamesystem();
        DataNode dn = this.cluster.getDataNodes().get(0);
        DatanodeDescriptor dnd = NameNodeAdapter.getDatanode(fsn, dn.getDatanodeId());
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        final FsDatasetImpl fsDImpl = (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return fsDImpl.getNonPersistentReplicas() == 0;
            }
        }, (int)10, (int)3000);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        LOG.info("Restarting the DataNode");
        Assert.assertTrue((String)"DN did not restart properly", (boolean)this.cluster.restartDataNode(0, true));
        this.waitForBlockReport(dn, dnd);
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
    }

    @Test
    public void testDnRestartWithUnsavedReplicas() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().build();
        FsDatasetTestUtil.stopLazyWriter(this.cluster.getDataNodes().get(0));
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        LOG.info("Restarting the DataNode");
        this.cluster.restartDataNode(0, true);
        this.cluster.waitActive();
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
    }

    private boolean waitForBlockReport(DataNode dn, DatanodeDescriptor dnd) throws IOException, InterruptedException {
        final DatanodeStorageInfo storage = dnd.getStorageInfos()[0];
        final long lastCount = storage.getBlockReportCount();
        dn.triggerBlockReport(new BlockReportOptions.Factory().setIncremental(false).build());
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return lastCount != (long)storage.getBlockReportCount();
                }
            }, (int)10, (int)10000);
        }
        catch (TimeoutException te) {
            LOG.error("Timeout waiting for block report for datanode: " + dnd);
            return false;
        }
        return true;
    }
}

