/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.bulkdatagenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.util.bulkdatagenerator.BulkDataGeneratorInputSplit;
import org.apache.hadoop.hbase.util.bulkdatagenerator.BulkDataGeneratorRecordReader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;

public class BulkDataGeneratorInputFormat
extends InputFormat<Text, NullWritable> {
    public static final String MAPPER_TASK_COUNT_KEY = BulkDataGeneratorInputFormat.class.getName() + "mapper.task.count";

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        int mapperCount = job.getConfiguration().getInt(MAPPER_TASK_COUNT_KEY, -1);
        Preconditions.checkArgument((mapperCount > 1 ? 1 : 0) != 0, (Object)(MAPPER_TASK_COUNT_KEY + " is not set."));
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (int i = 0; i < mapperCount; ++i) {
            splits.add(new BulkDataGeneratorInputSplit());
        }
        return splits;
    }

    public RecordReader<Text, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        BulkDataGeneratorRecordReader bulkDataGeneratorRecordReader = new BulkDataGeneratorRecordReader();
        bulkDataGeneratorRecordReader.initialize(split, context);
        return bulkDataGeneratorRecordReader;
    }
}

