/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.ganglia;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.ganglia.GangliaContext;
import org.apache.hadoop.net.DNS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GangliaContext31
extends GangliaContext {
    String hostName = "UNKNOWN.example.com";
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.util.GangliaContext31");

    @Override
    public void init(String contextName, ContextFactory factory) {
        super.init(contextName, factory);
        LOG.debug("Initializing the GangliaContext31 for Ganglia 3.1 metrics.");
        Configuration conf = new Configuration();
        if (conf.get("slave.host.name") != null) {
            this.hostName = conf.get("slave.host.name");
        } else {
            try {
                this.hostName = DNS.getDefaultHost(conf.get("dfs.datanode.dns.interface", "default"), conf.get("dfs.datanode.dns.nameserver", "default"));
            }
            catch (UnknownHostException uhe) {
                LOG.error(uhe.toString());
                this.hostName = "UNKNOWN.example.com";
            }
        }
    }

    @Override
    protected void emitMetric(String name, String type, String value) throws IOException {
        DatagramPacket packet;
        if (name == null) {
            LOG.warn("Metric was emitted with no name.");
            return;
        }
        if (value == null) {
            LOG.warn("Metric name " + name + " was emitted with a null value.");
            return;
        }
        if (type == null) {
            LOG.warn("Metric name " + name + ", value " + value + " has no type.");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Emitting metric " + name + ", type " + type + ", value " + value + " from hostname" + this.hostName);
        }
        String units = this.getUnits(name);
        int slope = this.getSlope(name);
        int tmax = this.getTmax(name);
        int dmax = this.getDmax(name);
        this.offset = 0;
        String groupName = name.substring(0, name.lastIndexOf("."));
        this.xdr_int(128);
        this.xdr_string(this.hostName);
        this.xdr_string(name);
        this.xdr_int(0);
        this.xdr_string(type);
        this.xdr_string(name);
        this.xdr_string(units);
        this.xdr_int(slope);
        this.xdr_int(tmax);
        this.xdr_int(dmax);
        this.xdr_int(1);
        this.xdr_string("GROUP");
        this.xdr_string(groupName);
        for (SocketAddress socketAddress : this.metricsServers) {
            packet = new DatagramPacket(this.buffer, this.offset, socketAddress);
            this.datagramSocket.send(packet);
        }
        this.offset = 0;
        this.xdr_int(133);
        this.xdr_string(this.hostName);
        this.xdr_string(name);
        this.xdr_int(0);
        this.xdr_string("%s");
        this.xdr_string(value);
        for (SocketAddress socketAddress : this.metricsServers) {
            packet = new DatagramPacket(this.buffer, this.offset, socketAddress);
            this.datagramSocket.send(packet);
        }
    }
}

