/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.mapreduce;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.RestoreJob;
import org.apache.hadoop.hbase.backup.mapreduce.MapReduceHFileSplitterJob;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hadoop.util.Tool;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MapReduceRestoreJob
implements RestoreJob {
    public static final Logger LOG = LoggerFactory.getLogger(MapReduceRestoreJob.class);
    private Tool player;
    private Configuration conf;

    @Override
    public void run(Path[] dirPaths, TableName[] tableNames, Path restoreRootDir, TableName[] newTableNames, boolean fullBackupRestore) throws IOException {
        this.player = new MapReduceHFileSplitterJob();
        String bulkOutputConfKey = "hfile.bulk.output";
        String dirs = StringUtils.join((Object[])dirPaths, (String)",");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Restore " + (fullBackupRestore ? "full" : "incremental") + " backup from directory " + dirs + " from hbase tables " + StringUtils.join((Object[])tableNames, (String)",") + " to tables " + StringUtils.join((Object[])newTableNames, (String)","));
        }
        for (int i = 0; i < tableNames.length; ++i) {
            LOG.info("Restore " + tableNames[i] + " into " + newTableNames[i]);
            Path bulkOutputPath = BackupUtils.getBulkOutputDir(restoreRootDir, BackupUtils.getFileNameCompatibleString(newTableNames[i]), this.getConf());
            Configuration conf = this.getConf();
            conf.set(bulkOutputConfKey, bulkOutputPath.toString());
            String[] playerArgs = new String[]{dirs, newTableNames[i].getNameAsString()};
            try {
                BulkLoadHFiles loader;
                this.player.setConf(this.getConf());
                int result = this.player.run(playerArgs);
                if (BackupUtils.succeeded(result)) {
                    loader = BackupUtils.createLoader(this.getConf());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Restoring HFiles from directory " + bulkOutputPath);
                    }
                } else {
                    throw new IOException("Can not restore from backup directory " + dirs + " (check Hadoop/MR and HBase logs). Player return code =" + result);
                }
                loader.bulkLoad(newTableNames[i], bulkOutputPath);
                LOG.debug("Restore Job finished:" + result);
                continue;
            }
            catch (Exception e) {
                LOG.error(e.toString(), (Throwable)e);
                throw new IOException("Can not restore from backup directory " + dirs + " (check Hadoop and HBase logs) ", e);
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }
}

