/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HealthChecker;
import org.apache.hadoop.hbase.HealthReport;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HealthCheckChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckChore.class);
    private HealthChecker healthChecker;
    private Configuration config;
    private int threshold;
    private int numTimesUnhealthy = 0;
    private long failureWindow;
    private long startWindow;

    public HealthCheckChore(int sleepTime, Stoppable stopper, Configuration conf) {
        super("HealthChecker", stopper, sleepTime);
        LOG.info("Health Check Chore runs every " + StringUtils.formatTime((long)sleepTime));
        this.config = conf;
        String healthCheckScript = this.config.get("hbase.node.health.script.location");
        long scriptTimeout = this.config.getLong("hbase.node.health.script.timeout", 60000L);
        this.healthChecker = new HealthChecker();
        this.healthChecker.init(healthCheckScript, scriptTimeout);
        this.threshold = this.config.getInt("hbase.node.health.failure.threshold", 3);
        this.failureWindow = (long)this.threshold * (long)sleepTime;
    }

    @Override
    protected void chore() {
        boolean isHealthy;
        HealthReport report = this.healthChecker.checkHealth();
        boolean bl = isHealthy = report.getStatus() == HealthChecker.HealthCheckerExitStatus.SUCCESS;
        if (!isHealthy) {
            boolean needToStop = this.decideToStop();
            if (needToStop) {
                this.getStopper().stop("The  node reported unhealthy " + this.threshold + " number of times consecutively.");
            }
            LOG.info("Health status at " + StringUtils.formatTime((long)EnvironmentEdgeManager.currentTime()) + " : " + report.getHealthReport());
        }
    }

    private boolean decideToStop() {
        boolean stop = false;
        if (this.numTimesUnhealthy == 0) {
            ++this.numTimesUnhealthy;
            this.startWindow = EnvironmentEdgeManager.currentTime();
        } else if (EnvironmentEdgeManager.currentTime() - this.startWindow < this.failureWindow) {
            ++this.numTimesUnhealthy;
            stop = this.numTimesUnhealthy == this.threshold;
        } else {
            this.numTimesUnhealthy = 1;
            this.startWindow = EnvironmentEdgeManager.currentTime();
            stop = false;
        }
        return stop;
    }
}

