/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.org.eclipse.jetty.http.pathmap;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hbase.thirdparty.org.eclipse.jetty.http.pathmap.AbstractPathSpec;
import org.apache.hbase.thirdparty.org.eclipse.jetty.http.pathmap.MatchedPath;
import org.apache.hbase.thirdparty.org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.apache.hbase.thirdparty.org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.apache.hbase.thirdparty.org.eclipse.jetty.util.log.Log;
import org.apache.hbase.thirdparty.org.eclipse.jetty.util.log.Logger;

public class RegexPathSpec
extends AbstractPathSpec {
    private static final Logger LOG = Log.getLogger(UriTemplatePathSpec.class);
    private static final Map<Character, String> FORBIDDEN_ESCAPED = new HashMap<Character, String>();
    private final String _declaration;
    private final PathSpecGroup _group;
    private final int _pathDepth;
    private final int _specLength;
    private final Pattern _pattern;

    public RegexPathSpec(String regex) {
        String declaration = regex.startsWith("regex|") ? regex.substring("regex|".length()) : regex;
        int specLength = declaration.length();
        boolean inTextList = false;
        boolean inQuantifier = false;
        StringBuilder signature = new StringBuilder();
        int pathDepth = 0;
        char last = '\u0000';
        for (int i = 0; i < declaration.length(); ++i) {
            char c = declaration.charAt(i);
            block0 : switch (c) {
                case '$': 
                case '\'': 
                case '(': 
                case ')': 
                case '^': {
                    break;
                }
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '|': {
                    signature.append('g');
                    break;
                }
                case '{': {
                    inQuantifier = true;
                    break;
                }
                case '}': {
                    inQuantifier = false;
                    break;
                }
                case '[': {
                    inTextList = true;
                    break;
                }
                case ']': {
                    inTextList = false;
                    signature.append('g');
                    break;
                }
                case '/': {
                    if (inTextList || inQuantifier) break;
                    ++pathDepth;
                    break;
                }
                default: {
                    if (inTextList || inQuantifier || !Character.isLetterOrDigit(c)) break;
                    if (last == '\\') {
                        String forbiddenReason = FORBIDDEN_ESCAPED.get(Character.valueOf(c));
                        if (forbiddenReason != null) {
                            throw new IllegalArgumentException(String.format("%s does not support \\%c (%s) for \"%s\"", this.getClass().getSimpleName(), Character.valueOf(c), forbiddenReason, declaration));
                        }
                        switch (c) {
                            case 'D': 
                            case 'S': 
                            case 'W': 
                            case 'd': 
                            case 'w': {
                                signature.append('g');
                                break block0;
                            }
                        }
                        signature.append('l');
                        break;
                    }
                    signature.append('l');
                }
            }
            last = c;
        }
        Pattern pattern = Pattern.compile(declaration);
        String sig = signature.toString();
        PathSpecGroup group = Pattern.matches("^l*$", sig) ? PathSpecGroup.EXACT : (Pattern.matches("^l*g+", sig) ? PathSpecGroup.PREFIX_GLOB : (Pattern.matches("^g+l+.*", sig) ? PathSpecGroup.SUFFIX_GLOB : PathSpecGroup.MIDDLE_GLOB));
        this._declaration = declaration;
        this._group = group;
        this._pathDepth = pathDepth;
        this._specLength = specLength;
        this._pattern = pattern;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating RegexPathSpec[{}] (signature: [{}], group: {})", new Object[]{this._declaration, sig, this._group});
        }
    }

    protected Matcher getMatcher(String path) {
        int idx = path.indexOf(63);
        if (idx >= 0) {
            return this._pattern.matcher(path.substring(0, idx));
        }
        return this._pattern.matcher(path);
    }

    @Override
    public int getSpecLength() {
        return this._specLength;
    }

    @Override
    public PathSpecGroup getGroup() {
        return this._group;
    }

    @Override
    public int getPathDepth() {
        return this._pathDepth;
    }

    @Override
    public String getPathInfo(String path) {
        Matcher matcher;
        if (this._group == PathSpecGroup.PREFIX_GLOB && (matcher = this.getMatcher(path)).matches() && matcher.groupCount() >= 1) {
            String pathInfo = matcher.group(1);
            if ("".equals(pathInfo)) {
                return "/";
            }
            return pathInfo;
        }
        return null;
    }

    @Override
    public String getPathMatch(String path) {
        Matcher matcher = this.getMatcher(path);
        if (matcher.matches()) {
            int idx;
            if (this._group == PathSpecGroup.PREFIX_GLOB && matcher.groupCount() >= 1 && (idx = matcher.start(1)) > 0) {
                if (path.charAt(idx - 1) == '/') {
                    --idx;
                }
                return path.substring(0, idx);
            }
            return path;
        }
        return null;
    }

    @Override
    public String getDeclaration() {
        return this._declaration;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getSuffix() {
        return null;
    }

    public Pattern getPattern() {
        return this._pattern;
    }

    @Override
    public boolean matches(String path) {
        return this.getMatcher(path).matches();
    }

    @Override
    public MatchedPath matched(String path) {
        Matcher matcher = this.getMatcher(path);
        if (matcher.matches()) {
            return new RegexMatchedPath(this, path, matcher);
        }
        return null;
    }

    static {
        FORBIDDEN_ESCAPED.put(Character.valueOf('s'), "any whitespace");
        FORBIDDEN_ESCAPED.put(Character.valueOf('n'), "newline");
        FORBIDDEN_ESCAPED.put(Character.valueOf('r'), "carriage return");
        FORBIDDEN_ESCAPED.put(Character.valueOf('t'), "tab");
        FORBIDDEN_ESCAPED.put(Character.valueOf('f'), "form-feed");
        FORBIDDEN_ESCAPED.put(Character.valueOf('b'), "bell");
        FORBIDDEN_ESCAPED.put(Character.valueOf('e'), "escape");
        FORBIDDEN_ESCAPED.put(Character.valueOf('c'), "control char");
    }

    private class RegexMatchedPath
    implements MatchedPath {
        private final RegexPathSpec pathSpec;
        private final String path;
        private final Matcher matcher;

        public RegexMatchedPath(RegexPathSpec regexPathSpec2, String path, Matcher matcher) {
            this.pathSpec = regexPathSpec2;
            this.path = path;
            this.matcher = matcher;
        }

        @Override
        public String getPathMatch() {
            int idx;
            try {
                String p = this.matcher.group("name");
                if (p != null) {
                    return p;
                }
            }
            catch (IllegalArgumentException p) {
                // empty catch block
            }
            if (this.pathSpec.getGroup() == PathSpecGroup.PREFIX_GLOB && this.matcher.groupCount() >= 1 && (idx = this.matcher.start(1)) > 0) {
                if (this.path.charAt(idx - 1) == '/') {
                    --idx;
                }
                return this.path.substring(0, idx);
            }
            return this.path;
        }

        @Override
        public String getPathInfo() {
            try {
                String p = this.matcher.group("info");
                if (p != null) {
                    return p;
                }
            }
            catch (IllegalArgumentException p) {
                // empty catch block
            }
            if (this.pathSpec.getGroup() == PathSpecGroup.PREFIX_GLOB && this.matcher.groupCount() >= 1) {
                String pathInfo = this.matcher.group(1);
                if ("".equals(pathInfo)) {
                    return "/";
                }
                return pathInfo;
            }
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[pathSpec=" + this.pathSpec + ", path=\"" + this.path + "\", matcher=" + this.matcher + ']';
        }
    }
}

